"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualFlowForm = ManualFlowForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uncontrolled_streams_app_bar = require("../../../streams_app_search_bar/uncontrolled_streams_app_bar");
var _preview_data_spark_plot = require("../common/preview_data_spark_plot");
var _validate_query = require("../common/validate_query");
var _default_query = require("../utils/default_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/manual_flow_form/manual_flow_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ManualFlowForm({
  definition,
  query,
  setQuery,
  setCanSave,
  isSubmitting,
  features,
  dataViews
}) {
  var _options$find;
  const [touched, setTouched] = (0, _react.useState)({
    title: false,
    feature: false,
    kql: false
  });
  const validation = (0, _validate_query.validateQuery)(query);
  (0, _react.useEffect)(() => {
    const isValid = !validation.title.isInvalid && !validation.kql.isInvalid;
    const isTouched = touched.title || touched.kql || touched.feature;
    setCanSave(isValid && isTouched);
  }, [validation, setCanSave, touched]);
  const options = features.map(feature => ({
    value: feature,
    inputDisplay: feature.name
  })).concat([{
    value: _default_query.NO_FEATURE,
    inputDisplay: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.noFeatureOptionLabel', {
      defaultMessage: 'No feature'
    })
  }]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, touched.title && {
    ...validation.title
  }, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.formFieldTitleLabel', {
      defaultMessage: 'Title'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: query === null || query === void 0 ? void 0 : query.title,
    disabled: isSubmitting,
    onBlur: () => {
      setTouched(prev => ({
        ...prev,
        title: true
      }));
    },
    onChange: event => {
      const next = event.currentTarget.value;
      setQuery({
        ...query,
        title: next
      });
      setTouched(prev => ({
        ...prev,
        title: true
      }));
    },
    placeholder: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.titlePlaceholder', {
      defaultMessage: 'Add title'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.formFieldFeatureLabel', {
      defaultMessage: 'Feature'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: (_options$find = options.find(option => {
      var _query$feature;
      return option.value.name === ((_query$feature = query.feature) === null || _query$feature === void 0 ? void 0 : _query$feature.name);
    })) === null || _options$find === void 0 ? void 0 : _options$find.value,
    placeholder: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.featurePlaceholder', {
      defaultMessage: 'Select feature'
    }),
    disabled: isSubmitting || features.length === 0,
    onBlur: () => {
      setTouched(prev => ({
        ...prev,
        feature: true
      }));
    },
    onChange: value => {
      setQuery({
        ...query,
        feature: value
      });
      setTouched(prev => ({
        ...prev,
        feature: true
      }));
    },
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.formFieldQueryLabel', {
      defaultMessage: 'Query'
    }))
  }, touched.kql && {
    ...validation.kql
  }, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_uncontrolled_streams_app_bar.UncontrolledStreamsAppSearchBar, {
    query: query.kql ? {
      language: 'kuery',
      ...query.kql
    } : {
      language: 'kuery',
      query: ''
    },
    showQueryInput: true,
    showSubmitButton: false,
    isDisabled: isSubmitting,
    onQueryChange: () => {
      setTouched(prev => ({
        ...prev,
        kql: true
      }));
    },
    onQuerySubmit: next => {
      var _next$query;
      setQuery({
        ...query,
        kql: {
          query: typeof ((_next$query = next.query) === null || _next$query === void 0 ? void 0 : _next$query.query) === 'string' ? next.query.query : ''
        }
      });
      setTouched(prev => ({
        ...prev,
        kql: true
      }));
    },
    placeholder: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.queryPlaceholder', {
      defaultMessage: 'Enter query'
    }),
    indexPatterns: dataViews,
    submitOnBlur: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_preview_data_spark_plot.PreviewDataSparkPlot, {
    definition: definition,
    query: query,
    isQueryValid: !validation.kql.isInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  })));
}