"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSignificantEventFlyout = AddSignificantEventFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _uuid = require("uuid");
var _rxjs = require("rxjs");
var _get_stream_type_from_definition = require("../../../util/get_stream_type_from_definition");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_significant_events_api = require("../../../hooks/use_significant_events_api");
var _flow_selector = require("./flow_selector");
var _generated_flow_form = require("./generated_flow_form/generated_flow_form");
var _manual_flow_form = require("./manual_flow_form/manual_flow_form");
var _default_query = require("./utils/default_query");
var _streams_app_search_bar = require("../../streams_app_search_bar");
var _feature_selector = require("../feature_selector");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _use_ai_features = require("./generated_flow_form/use_ai_features");
var _validate_query = require("./common/validate_query");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/add_significant_event_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AddSignificantEventFlyout({
  query,
  onClose,
  definition,
  onSave,
  initialFlow = undefined,
  initialSelectedFeatures = [],
  features
}) {
  var _aiFeatures$genAiConn, _dataViewsFetch$value, _dataViewsFetch$value2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    core: {
      notifications
    },
    services: {
      telemetryClient
    },
    dependencies: {
      start: {
        data
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState: {
      start,
      end
    }
  } = (0, _use_timefilter.useTimefilter)();
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const dataViewsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(() => {
    return data.dataViews.create({
      title: definition.name
    }).then(value => {
      return [value];
    });
  }, [data.dataViews, definition.name]);
  const {
    generate,
    abort
  } = (0, _use_significant_events_api.useSignificantEventsApi)({
    name: definition.name,
    start,
    end
  });
  const isEditMode = !!(query !== null && query !== void 0 && query.id);
  const [selectedFlow, setSelectedFlow] = (0, _react.useState)(isEditMode ? 'manual' : initialFlow);
  const flowRef = (0, _react.useRef)(selectedFlow);
  const [queries, setQueries] = (0, _react.useState)([{
    ...(0, _default_query.defaultQuery)(),
    ...query
  }]);
  const [canSave, setCanSave] = (0, _react.useState)(false);
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const [selectedFeatures, setSelectedFeatures] = (0, _react.useState)(initialSelectedFeatures);
  const [isGenerating, setIsGenerating] = (0, _react.useState)(false);
  const [generatedQueries, setGeneratedQueries] = (0, _react.useState)([]);
  const stopGeneration = (0, _react.useCallback)(() => {
    setIsGenerating(false);
    abort();
  }, [abort]);
  const parsedQueries = (0, _react.useMemo)(() => {
    return _streamsSchema.streamQuerySchema.array().safeParse(queries);
  }, [queries]);
  (0, _react.useEffect)(() => {
    if (flowRef.current !== selectedFlow) {
      flowRef.current = selectedFlow;
      setIsSubmitting(false);
      setCanSave(false);
      setQueries([(0, _default_query.defaultQuery)()]);
    }
  }, [selectedFlow]);
  const generateQueries = (0, _react.useCallback)(() => {
    const connector = aiFeatures === null || aiFeatures === void 0 ? void 0 : aiFeatures.genAiConnectors.selectedConnector;
    if (!connector || selectedFeatures.length === 0) {
      return;
    }
    const startTime = Date.now();
    setIsGenerating(true);
    setGeneratedQueries([]);
    (0, _rxjs.from)(selectedFeatures).pipe((0, _rxjs.concatMap)(feature => generate(connector, feature).pipe((0, _rxjs.concatMap)(result => {
      const validation = (0, _validate_query.validateQuery)({
        title: result.query.title,
        kql: {
          query: result.query.kql
        }
      });
      if (!validation.kql.isInvalid) {
        setGeneratedQueries(prev => [...prev, {
          id: (0, _uuid.v4)(),
          kql: {
            query: result.query.kql
          },
          title: result.query.title,
          feature: result.query.feature
        }]);
      }
      return [];
    })))).subscribe({
      error: error => {
        setIsGenerating(false);
        if (error.name === 'AbortError') {
          return;
        }
        notifications.showErrorDialog({
          title: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generateErrorToastTitle', {
            defaultMessage: `Could not generate significant events queries`
          }),
          error
        });
      },
      complete: () => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generateSuccessToastTitle', {
            defaultMessage: `Generated significant events queries successfully`
          })
        });
        telemetryClient.trackSignificantEventsSuggestionsGenerate({
          duration_ms: Date.now() - startTime,
          stream_type: (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(definition)
        });
        setIsGenerating(false);
      }
    });
  }, [aiFeatures, definition, generate, notifications, telemetryClient, selectedFeatures]);
  (0, _react.useEffect)(() => {
    if (initialFlow === 'ai' && initialSelectedFeatures.length > 0) {
      generateQueries();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [aiFeatures === null || aiFeatures === void 0 ? void 0 : aiFeatures.enabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": "addSignificantEventFlyout",
    onClose: () => onClose(),
    size: isEditMode ? 's' : 'l',
    type: isEditMode ? 'push' : 'overlay',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, isEditMode ? _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.editTitle', {
    defaultMessage: 'Edit significant events'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.createTitle', {
    defaultMessage: 'Add significant events'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: (0, _css.css)`
          & .euiFlyoutBody__overflow {
            mask-image: none;
          }
          & .euiFlyoutBody__overflowContent {
            height: 100%;
            padding: 0;
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: {
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, !isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: (0, _css.css)`
                border-right: 1px solid ${euiTheme.colors.borderBaseSubdued};
                height: 100%;
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.selectOptionLabel', {
    defaultMessage: 'Select a method'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_flow_selector.FlowSelector, {
    isSubmitting: isSubmitting,
    selected: selectedFlow,
    updateSelected: flow => {
      setSelectedFlow(flow);
      setSelectedFeatures([]);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  }), selectedFlow === 'ai' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_feature_selector.FeaturesSelector, {
    features: features,
    selectedFeatures: selectedFeatures,
    onFeaturesChange: setSelectedFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "sparkles",
    fill: true,
    isLoading: isGenerating,
    disabled: isSubmitting || selectedFeatures.length === 0 || !(aiFeatures !== null && aiFeatures !== void 0 && (_aiFeatures$genAiConn = aiFeatures.genAiConnectors) !== null && _aiFeatures$genAiConn !== void 0 && _aiFeatures$genAiConn.selectedConnector),
    onClick: generateQueries,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.generateSuggestionsButtonLabel', {
    defaultMessage: 'Generate suggestions'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    css: {
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      overflow: 'scroll'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 17
    }
  }, selectedFlow === 'manual' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 29
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.previewSignificantEventsLabel', {
    defaultMessage: 'Preview significant events'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    showDatePicker: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_manual_flow_form.ManualFlowForm, {
    isSubmitting: isSubmitting,
    setQuery: next => setQueries([next]),
    query: queries[0],
    setCanSave: next => {
      setCanSave(next);
    },
    definition: definition,
    dataViews: (_dataViewsFetch$value = dataViewsFetch.value) !== null && _dataViewsFetch$value !== void 0 ? _dataViewsFetch$value : [],
    features: features.map(feature => ({
      name: feature.name,
      filter: feature.filter
    })) || [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 23
    }
  })), selectedFlow === 'ai' && /*#__PURE__*/_react.default.createElement(_generated_flow_form.GeneratedFlowForm, {
    isGenerating: isGenerating,
    generatedQueries: generatedQueries,
    onEditQuery: editedQuery => {
      setGeneratedQueries(prev => prev.map(q => q.id === editedQuery.id ? editedQuery : q));
    },
    stopGeneration: stopGeneration,
    isSubmitting: isSubmitting,
    definition: definition,
    setQueries: next => {
      setQueries(next);
    },
    setCanSave: next => {
      setCanSave(next);
    },
    features: features,
    dataViews: (_dataViewsFetch$value2 = dataViewsFetch.value) !== null && _dataViewsFetch$value2 !== void 0 ? _dataViewsFetch$value2 : [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      padding: euiTheme.size.l
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: () => onClose(),
    disabled: isSubmitting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    disabled: !parsedQueries.success || !canSave || isGenerating,
    isLoading: isSubmitting,
    onClick: () => {
      setIsSubmitting(true);
      switch (selectedFlow) {
        case 'manual':
          onSave({
            type: 'single',
            query: queries[0],
            isUpdating: isEditMode
          }).finally(() => setIsSubmitting(false));
          break;
        case 'ai':
          onSave({
            type: 'multiple',
            queries
          }).finally(() => setIsSubmitting(false));
          break;
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 19
    }
  }, selectedFlow === 'manual' ? isEditMode ? _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.updateButtonLabel', {
    defaultMessage: 'Update event'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.addButtonLabel', {
    defaultMessage: 'Add event'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.addSelectedButtonLabel', {
    defaultMessage: 'Add selected'
  })))))))));
}