"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsTable = DashboardsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _use_kibana = require("../../hooks/use_kibana");
var _to_reference_list = require("./to_reference_list");
var _use_timefilter = require("../../hooks/use_timefilter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_dashboards_view/dashboard_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DashboardsTable({
  dashboards,
  compact = false,
  selectedDashboards,
  setSelectedDashboards,
  loading,
  entityId,
  dataTestSubj
}) {
  const {
    core: {
      application
    },
    services: {
      telemetryClient
    },
    dependencies: {
      start: {
        savedObjectsTagging: {
          ui: savedObjectsTaggingUi
        },
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const dashboardLocator = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'label',
      name: _i18n.i18n.translate('xpack.streams.dashboardTable.dashboardNameColumnTitle', {
        defaultMessage: 'Dashboard name'
      }),
      render: (_, {
        title,
        id
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "streamsAppDashboardColumnsLink",
        onClick: () => {
          if (entityId) {
            telemetryClient.trackAssetClick({
              asset_id: id,
              asset_type: 'dashboard',
              name: entityId
            });
          }
          const url = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl(
          // @ts-expect-error upgrade typescript v5.9.3
          {
            dashboardId: id,
            timeRange: timeState.timeRange
          } || '');
          if (url) {
            application.navigateToUrl(url);
          }
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 11
        }
      }, title)
    }, ...(!compact ? [{
      field: 'tags',
      name: _i18n.i18n.translate('xpack.streams.dashboardTable.tagsColumnTitle', {
        defaultMessage: 'Tags'
      }),
      render: (_, {
        tags
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "row",
          gutterSize: "s",
          alignItems: "center",
          wrap: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(savedObjectsTaggingUi.components.TagList, {
          object: {
            references: (0, _to_reference_list.tagListToReferenceList)(tags)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 21
          }
        }));
      }
    }] : [])];
  }, [application, compact, dashboardLocator, entityId, savedObjectsTaggingUi, telemetryClient, timeState]);
  const items = (0, _react.useMemo)(() => {
    return dashboards !== null && dashboards !== void 0 ? dashboards : [];
  }, [dashboards]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": dataTestSubj,
    columns: columns,
    itemId: "id",
    items: items,
    loading: loading,
    selection: setSelectedDashboards ? {
      onSelectionChange: setSelectedDashboards,
      selected: selectedDashboards
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }));
}