"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDashboardFlyout = AddDashboardFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../hooks/use_streams_app_fetch");
var _dashboard_table = require("./dashboard_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_dashboards_view/add_dashboard_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AddDashboardFlyout({
  entityId,
  onAddDashboards,
  linkedDashboards,
  onClose
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        },
        savedObjectsTagging: {
          ui: savedObjectsTaggingUi
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [query, setQuery] = (0, _react.useState)('');
  const [submittedQuery, setSubmittedQuery] = (0, _react.useState)(query);
  const [selectedDashboards, setSelectedDashboards] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [selectedTags, setSelectedTags] = (0, _react.useState)([]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const setSubmittedQueryDebounced = (0, _react.useMemo)(() => {
    return (0, _lodash.debounce)(setSubmittedQuery, 150);
  }, []);
  const dashboardSuggestionsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('POST /internal/streams/{name}/dashboards/_suggestions', {
      signal,
      params: {
        path: {
          name: entityId
        },
        query: {
          query: submittedQuery
        },
        body: {
          tags: selectedTags
        }
      }
    }).then(({
      suggestions
    }) => {
      return {
        dashboards: suggestions.filter(dashboard => {
          return !linkedDashboards.find(linkedDashboard => linkedDashboard.id === dashboard.id);
        })
      };
    });
  }, [streamsRepositoryClient, entityId, submittedQuery, selectedTags, linkedDashboards]);
  const tagList = savedObjectsTaggingUi.getTagList();
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    isSelected: isPopoverOpen,
    numFilters: tagList.length,
    hasActiveFilters: selectedTags.length > 0,
    numActiveFilters: selectedTags.length,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.streams.addDashboardFlyout.filterButtonLabel', {
    defaultMessage: 'Tags'
  }));
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'addDashboardFlyoutTitle'
  });
  (0, _react.useEffect)(() => {
    setSelectedDashboards([]);
  }, [linkedDashboards]);
  const allDashboards = (0, _react.useMemo)(() => {
    var _dashboardSuggestions;
    return ((_dashboardSuggestions = dashboardSuggestionsFetch.value) === null || _dashboardSuggestions === void 0 ? void 0 : _dashboardSuggestions.dashboards) || [];
  }, [dashboardSuggestionsFetch.value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.addDashboardFlyout.flyoutHeaderLabel', {
    defaultMessage: 'Add dashboards'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.addDashboardFlyout.helpLabel', {
    defaultMessage: 'Select dashboards which you want to add and assign to the {stream} stream',
    values: {
      stream: entityId
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true
    },
    query: query,
    onChange: ({
      queryText
    }) => {
      setQuery(queryText);
      setSubmittedQueryDebounced(queryText);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    allowExclusions: true,
    searchable: true,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.streams.addDashboardFlyout.searchTagsLabel', {
        defaultMessage: 'Search tags'
      }),
      compressed: true
    },
    options: (tagList || []).map(tag => ({
      label: tag.name,
      checked: selectedTags.includes(tag.id) ? 'on' : undefined
    })),
    onChange: newOptions => {
      setSelectedTags(newOptions.filter(option => option.checked === 'on').map(option => savedObjectsTaggingUi.getTagIdFromName(option.label)));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 19
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 25
    }
  }, search), list)))))), /*#__PURE__*/_react.default.createElement(_dashboard_table.DashboardsTable, {
    entityId: entityId,
    dashboards: allDashboards,
    loading: dashboardSuggestionsFetch.loading,
    selectedDashboards: selectedDashboards,
    setSelectedDashboards: setSelectedDashboards,
    dataTestSubj: "streamsAppAddDashboardFlyoutDashboardsTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    disabled: selectedDashboards.length === 0,
    "data-test-subj": "streamsAppAddDashboardFlyoutAddDashboardsButton",
    onClick: async () => {
      setIsLoading(true);
      try {
        await onAddDashboards(selectedDashboards);
      } finally {
        setIsLoading(false);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.addDashboardFlyout.addDashboardsButtonLabel', {
    defaultMessage: 'Add dashboards'
  }))));
}