"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesWarningIconWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _tooltip_popover_icon = require("../tooltip_popover_icon/tooltip_popover_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/insufficient_privileges/insufficient_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const insufficientPrivilegesText = _i18n.i18n.translate('xpack.streams.insufficientPrivilegesMessage', {
  defaultMessage: "You don't have sufficient privileges to access this information."
});
const PrivilegesWarningIconWrapper = ({
  hasPrivileges,
  title,
  mode = 'popover',
  iconColor = 'warning',
  popoverCss,
  children
}) => {
  if (hasPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return /*#__PURE__*/_react.default.createElement(_tooltip_popover_icon.TooltipOrPopoverIcon, {
    dataTestSubj: `streamsInsufficientPrivileges-${title}`,
    title: insufficientPrivilegesText,
    mode: mode,
    icon: "warning",
    iconColor: iconColor,
    popoverCss: popoverCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, children);
};
exports.PrivilegesWarningIconWrapper = PrivilegesWarningIconWrapper;