"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailSchemaEditor = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_discard_confirm = require("../../../hooks/use_discard_confirm");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _schema_editor = require("../schema_editor");
var _constants = require("../schema_editor/constants");
var _use_schema_fields = require("../schema_editor/hooks/use_schema_fields");
var _schema_changes_review_modal = require("../schema_editor/schema_changes_review_modal");
var _streams_app_context_provider = require("../../streams_app_context_provider");
var _get_stream_type_from_definition = require("../../../util/get_stream_type_from_definition");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_schema_editor/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const wiredDefaultColumns = _constants.DEFAULT_TABLE_COLUMN_NAMES;
const classicDefaultColumns = _constants.DEFAULT_TABLE_COLUMN_NAMES.filter(column => column !== 'parent');
const StreamDetailSchemaEditor = ({
  definition,
  refreshDefinition
}) => {
  const context = (0, _use_kibana.useKibana)();
  const {
    loading
  } = (0, _use_stream_detail.useStreamDetail)();
  const [selectedFields, setSelectedFields] = _react.default.useState([]);
  const {
    fields,
    isLoadingFields,
    refreshFields,
    addField,
    updateField,
    pendingChangesCount,
    discardChanges,
    submitChanges
  } = (0, _use_schema_fields.useSchemaFields)({
    definition,
    refreshDefinition
  });
  const definitionFields = _react.default.useMemo(() => (0, _use_schema_fields.getDefinitionFields)(definition), [definition]);
  const definitionFieldMap = _react.default.useMemo(() => {
    const map = new Set();
    definitionFields.forEach(field => map.add(field.name));
    return map;
  }, [definitionFields]);
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: pendingChangesCount > 0,
    history: context.appParams.history,
    http: context.core.http,
    navigateToUrl: context.core.application.navigateToUrl,
    openConfirm: context.core.overlays.openConfirm,
    shouldPromptOnReplace: false
  });
  const handleCancelClick = (0, _use_discard_confirm.useDiscardConfirm)(discardChanges, {
    defaultFocusedButton: 'cancel'
  });
  const openConfirmationModal = () => {
    const overlay = context.core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_streams_app_context_provider.StreamsAppContextProvider, {
      context: context,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_schema_changes_review_modal.SchemaChangesReviewModal, {
      fields: fields.filter(field => field.status !== 'unmapped' || definitionFieldMap.has(field.name)),
      streamType: (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(definition.stream),
      definition: definition,
      storedFields: definitionFields,
      submitChanges: submitChanges,
      onClose: () => overlay.close(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    })), context.core), {
      maxWidth: 500
    });
  };
  const isRootStream = (0, _streamsSchema.isRootStreamDefinition)(definition.stream);
  const handleAddField = !isRootStream && definition.privileges.manage ? addField : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    css: {
      height: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, isRootStream && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: _i18n.i18n.translate('xpack.streams.schemaEditor.rootStreamReadOnlyMode', {
      defaultMessage: 'Root streams are selectively immutable and their schema cannot be modified. To modify the schema or to add processing steps, partition a new child stream first.'
    }),
    announceOnMount: false,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      minHeight: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_schema_editor.SchemaEditor, {
    fields: fields,
    isLoading: loading || isLoadingFields,
    defaultColumns: _streamsSchema.Streams.WiredStream.GetResponse.is(definition) ? wiredDefaultColumns : classicDefaultColumns,
    stream: definition.stream,
    onAddField: handleAddField,
    onFieldUpdate: updateField,
    onRefreshData: refreshFields,
    onFieldSelection: (names, checked) => {
      setSelectedFields(selection => {
        if (checked) {
          return (0, _lodash.uniq)([...selection, ...names]);
        } else {
          return selection.filter(name => !names.includes(name));
        }
      });
    },
    fieldSelection: selectedFields,
    withControls: true,
    withFieldSimulation: true,
    withTableActions: !isRootStream && definition.privileges.manage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  })), pendingChangesCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    position: "static",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.schemaEditor.changesPendingLabel",
    defaultMessage: "{count, plural, one {# change pending. Review and submit when ready.} other {# changes pending. Review and submit when ready.}}",
    values: {
      count: pendingChangesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: handleCancelClick,
    "data-test-subj": "streamsAppSchemaEditorDiscardChangesButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.schemaEditor.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: openConfirmationModal,
    "data-test-subj": "streamsAppSchemaEditorReviewStagedChangesButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.schemaEditor.submitChangesButtonLabel",
    defaultMessage: "Submit changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 23
    }
  })))))))));
};
exports.StreamDetailSchemaEditor = StreamDetailSchemaEditor;