"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamsRoutingSelector = exports.useStreamsRoutingActorRef = exports.useStreamSamplesSelector = exports.useStreamSamplesRef = exports.useStreamRoutingEvents = exports.StreamRoutingContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@xstate5/react");
var _xstateUtils = require("@kbn/xstate-utils");
var _xstate = require("xstate5");
var _stream_routing_state_machine = require("./stream_routing_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/state_management/stream_routing_state_machine/use_stream_routing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const consoleInspector = (0, _xstateUtils.createConsoleInspector)();
const StreamRoutingContext = (0, _react2.createActorContext)(_stream_routing_state_machine.streamRoutingMachine);
const useStreamsRoutingSelector = exports.useStreamsRoutingSelector = StreamRoutingContext.useSelector;
const useStreamsRoutingActorRef = exports.useStreamsRoutingActorRef = StreamRoutingContext.useActorRef;
const useStreamRoutingEvents = () => {
  const service = StreamRoutingContext.useActorRef();
  return (0, _react.useMemo)(() => ({
    cancelChanges: () => {
      service.send({
        type: 'routingRule.cancel'
      });
    },
    changeRule: routingRule => {
      service.send({
        type: 'routingRule.change',
        routingRule
      });
    },
    createNewRule: () => {
      service.send({
        type: 'routingRule.create'
      });
    },
    removeRule: async () => {
      service.send({
        type: 'routingRule.remove'
      });
      await (0, _xstate.waitFor)(service, snapshot => snapshot.matches({
        ready: 'idle'
      }));
    },
    reorderRules: routing => {
      service.send({
        type: 'routingRule.reorder',
        routing
      });
    },
    editRule: id => {
      service.send({
        type: 'routingRule.edit',
        id
      });
    },
    forkStream: async routingRule => {
      service.send({
        type: 'routingRule.fork',
        routingRule
      });
      await (0, _xstate.waitFor)(service, snapshot => snapshot.matches({
        ready: 'idle'
      }));
    },
    saveChanges: () => {
      service.send({
        type: 'routingRule.save'
      });
    },
    setDocumentMatchFilter: filter => {
      service.send({
        type: 'routingSamples.setDocumentMatchFilter',
        filter
      });
    },
    reviewSuggestedRule: id => {
      service.send({
        type: 'routingRule.reviewSuggested',
        id
      });
    }
  }), [service]);
};
exports.useStreamRoutingEvents = useStreamRoutingEvents;
const StreamRoutingContextProvider = ({
  children,
  definition,
  ...deps
}) => {
  return /*#__PURE__*/_react.default.createElement(StreamRoutingContext.Provider, {
    logic: _stream_routing_state_machine.streamRoutingMachine.provide((0, _stream_routing_state_machine.createStreamRoutingMachineImplementations)(deps)),
    options: {
      id: 'streamRouting',
      inspect: consoleInspector,
      input: {
        definition
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ListenForDefinitionChanges, {
    definition: definition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, children));
};
exports.StreamRoutingContextProvider = StreamRoutingContextProvider;
const ListenForDefinitionChanges = ({
  children,
  definition
}) => {
  const service = StreamRoutingContext.useActorRef();
  (0, _react.useEffect)(() => {
    service.send({
      type: 'stream.received',
      definition
    });
  }, [definition, service]);
  return children;
};
const useStreamSamplesRef = () => {
  return useStreamsRoutingSelector(state => state.children.routingSamplesMachine);
};
exports.useStreamSamplesRef = useStreamSamplesRef;
const useStreamSamplesSelector = selector => {
  const routingSamplesRef = useStreamSamplesRef();
  if (!routingSamplesRef) {
    throw new Error('useStreamSamplesSelector must be used within a StreamEnrichmentContextProvider');
  }
  return (0, _react2.useSelector)(routingSamplesRef, selector);
};
exports.useStreamSamplesSelector = useStreamSamplesSelector;