"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoutingConditionEditor = RoutingConditionEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_field_suggestions = require("../../../hooks/use_field_suggestions");
var _condition_editor = require("../shared/condition_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/routing_condition_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RoutingConditionEditor(props) {
  const isEnabled = (0, _streamsSchema.isRoutingEnabled)(props.status);
  const fieldSuggestions = (0, _use_field_suggestions.useRoutingFieldSuggestions)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.routing.conditionEditor.title', {
      defaultMessage: 'Status'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.streams.routing.conditionEditor.disableTooltip', {
        defaultMessage: 'When disabled, the routing rule stops sending documents to this stream. It does not remove existing data.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.routing.conditionEditor.switch', {
      defaultMessage: 'Enabled'
    }),
    compressed: true,
    checked: isEnabled,
    onChange: event => props.onStatusChange(event.target.checked ? 'enabled' : 'disabled'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_condition_editor.ConditionEditor, (0, _extends2.default)({}, props, {
    fieldSuggestions: fieldSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  })));
}