"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureDetailExpanded = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _condition_display = require("../../shared/condition_display");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_features/feature_detail_expanded.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FeatureDetailExpanded = ({
  feature,
  setFeatures
}) => {
  const [isEditingCondition, toggleIsEditingCondition] = (0, _useToggle.default)(false);
  const setFeature = updated => {
    setFeatures(prev => prev.map(s => s.name === updated.name ? updated : s));
  };
  const handleConditionChange = newFilter => {
    setFeature({
      ...feature,
      filter: newFilter
    });
  };
  const handleDescriptionChange = newDescription => {
    setFeature({
      ...feature,
      description: newDescription
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.description', {
    defaultMessage: 'Description'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.markdownEditorAriaLabel', {
      defaultMessage: 'Feature description markdown editor'
    }),
    value: feature.description,
    onChange: handleDescriptionChange,
    height: 400,
    readOnly: false,
    initialViewMode: "viewing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.filter', {
    defaultMessage: 'Filter'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    onClick: toggleIsEditingCondition,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.featureDetailExpanded.filter.edit', {
      defaultMessage: 'Edit filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_condition_display.EditableConditionPanel, {
    condition: feature.filter,
    isEditingCondition: isEditingCondition,
    setCondition: handleConditionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  })));
};
exports.FeatureDetailExpanded = FeatureDetailExpanded;