"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCalculatedStats = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCalculatedStats = ({
  stats,
  timeState,
  buckets
}) => {
  if (!buckets) {
    return {
      bytesPerDoc: 0,
      bytesPerDay: 0
    };
  }
  const effectiveStart = getEffectiveStart(timeState, stats.creationDate);
  const rangeInDays = (0, _moment.default)(timeState.end).diff(effectiveStart, 'days', true);
  const countRange = buckets.reduce((sum, bucket) => sum + bucket.doc_count, 0);
  const bytesPerDoc = stats.totalDocs && stats.sizeBytes ? stats.sizeBytes / stats.totalDocs : 0;
  const perDayDocs = countRange ? countRange / rangeInDays : 0;
  const bytesPerDay = bytesPerDoc * perDayDocs;
  return {
    bytesPerDoc,
    bytesPerDay
  };
};
exports.getCalculatedStats = getCalculatedStats;
const getEffectiveStart = (timeState, creationDate) => {
  if (creationDate) {
    if (creationDate > timeState.start && creationDate < timeState.end) {
      return creationDate;
    }
  }
  return timeState.start;
};