"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmSummary = IlmSummary;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_ilm_phases_color_and_description = require("../hooks/use_ilm_phases_color_and_description");
var _format_size_units = require("../helpers/format_size_units");
var _format_bytes = require("../helpers/format_bytes");
var _helpers = require("../helpers/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/ilm_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IlmSummary({
  definition,
  stats
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value,
    loading,
    error
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /internal/streams/{name}/lifecycle/_stats', {
      params: {
        path: {
          name: definition.stream.name
        }
      },
      signal
    });
  },
  // we pass the stats as a hack to refresh the ilm summary
  // when the ingestion rate graph is refreshed
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [streamsRepositoryClient, definition, stats]);
  const phasesWithGrow = (0, _react.useMemo)(() => {
    return (0, _helpers.getILMRatios)(value);
  }, [value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "ilmSummary-title",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ilmDataTiers', {
    defaultMessage: 'ILM policy data tiers'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "ilmSummary-loading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: true,
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, error || !phasesWithGrow ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, phasesWithGrow.map((phase, index) => {
    var _phasesWithGrow;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${phase.name}-timeline`,
      grow: phase.grow,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(IlmPhase, {
      phase: phase,
      minAge: (_phasesWithGrow = phasesWithGrow[index - 1]) === null || _phasesWithGrow === void 0 ? void 0 : _phasesWithGrow.min_age,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }));
  }))));
}
function IlmPhase({
  phase,
  minAge
}) {
  const borderRadius = phase.name === 'delete' ? minAge ? '4px 4px 4px 4px' : '4px 0px 0px 4px' : phase.name === 'hot' ? minAge ? '0px 4px 4px 0px' : '0px' : minAge ? '0px' : '4px 0px 0px 4px';
  const {
    ilmPhases
  } = (0, _use_ilm_phases_color_and_description.useIlmPhasesColorAndDescription)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasBorder: false,
    hasShadow: false,
    css: {
      backgroundColor: ilmPhases[phase.name].color,
      margin: '0',
      borderRadius,
      borderRight: phase.name !== 'delete' ? `1px solid ${euiTheme.colors.backgroundBasePlain}` : undefined,
      paddingLeft: phase.name !== 'hot' ? `1px solid ${euiTheme.colors.backgroundBasePlain}` : undefined,
      minHeight: '50px'
    },
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, phase.name === 'delete' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `ilmPhase-${phase.name}-icon`,
    css: {
      height: '100%',
      textAlign: 'center',
      display: 'flex',
      alignItems: 'center',
      minWidth: '30px',
      justifyContent: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "trash",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.plainDark,
    textAlign: "right",
    "data-test-subj": `ilmPhase-${phase.name}-name`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }, (0, _lodash.capitalize)(phase.name))), 'size_in_bytes' in phase && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.plainDark,
    textAlign: "right",
    "data-test-subj": `ilmPhase-${phase.name}-size`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, (0, _format_bytes.formatBytes)(phase.size_in_bytes)))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    borderRadius: "none",
    hasBorder: false,
    hasShadow: false,
    grow: false,
    css: {
      paddingBottom: '5px',
      ...(phase.name !== 'delete' && {
        borderLeft: `1px solid ${ilmPhases.delete.color}`
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, phase.name !== 'delete' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    css: {
      marginLeft: minAge ? '-40px' : '-10px',
      width: minAge ? '80px' : '20px'
    },
    grow: false,
    hasBorder: false,
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, minAge ? (0, _format_size_units.getTimeSizeAndUnitLabel)(minAge) : '∞')) : undefined));
}