"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhereBlock = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@xstate5/react");
var _useFirstMountState = require("react-use/lib/useFirstMountState");
var _react3 = require("@emotion/react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18n = require("@kbn/i18n");
var _stream_enrichment_state_machine = require("../../../state_management/stream_enrichment_state_machine");
var _utils = require("../../../utils");
var _steps_list = require("../../steps_list");
var _configuration = require("./configuration");
var _summary = require("./summary");
var _connected_nodes_list = require("./connected_nodes_list");
var _steps_state_machine = require("../../../state_management/steps_state_machine");
var _utils2 = require("../../../state_management/stream_enrichment_state_machine/utils");
var _block_disable_overlay = require("../block_disable_overlay");
var _nested_children_processing_summary = require("./nested_children_processing_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/where/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WhereBlock = props => {
  const {
    stepRef,
    stepUnderEdit,
    rootLevelMap,
    stepsProcessingSummaryMap,
    level
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const stepRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.stepRefs);
  const isFirstMount = (0, _useFirstMountState.useFirstMountState)();
  const freshBlockRef = (0, _react.useRef)(null);
  const isUnderEdit = (0, _react2.useSelector)(stepRef, snapshot => (0, _steps_state_machine.isStepUnderEdit)(snapshot));
  const panelColour = (0, _utils.getStepPanelColour)(level);

  // Invert again
  const nestedSummaryPanelColour = (0, _utils.getStepPanelColour)(level + 1);
  const isRootStepValue = (0, _react2.useSelector)(stepRef, snapshot => (0, _steps_state_machine.isRootStep)(snapshot));
  const [isExpanded, toggle] = (0, _useToggle.default)(true);
  const step = (0, _react2.useSelector)(stepRef, snapshot => snapshot.context.step);
  const childSteps = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.stepRefs.filter(ref => ref.getSnapshot().context.step.parentId === step.customIdentifier));
  const hasChildren = childSteps.length > 0;

  // Only gather these for the summary if the block is collapsed
  const descendantIds = !isExpanded ? (0, _utils2.collectDescendantIds)(step.customIdentifier, stepRefs) : undefined;
  (0, _react.useEffect)(() => {
    if (isFirstMount && isUnderEdit && freshBlockRef.current) {
      freshBlockRef.current.scrollIntoView({
        behavior: 'smooth',
        block: 'start',
        inline: 'nearest'
      });
    }
  }, [isFirstMount, isUnderEdit]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "streamsAppConditionBlock",
    hasShadow: false,
    color: isUnderEdit && isRootStepValue ? undefined : panelColour,
    css: isUnderEdit ?
    // eslint-disable-next-line @elastic/eui/no-css-color
    (0, _react3.css)`
                border: 1px solid ${euiTheme.colors.borderStrongPrimary};
                box-sizing: border-box;
              ` : (0, _react3.css)`
                border: ${euiTheme.border.thin};
                padding: ${euiTheme.size.m};
                border-radius: ${euiTheme.size.s};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, stepUnderEdit && rootLevelMap.get(step.customIdentifier) !== rootLevelMap.get(stepUnderEdit.customIdentifier) && /*#__PURE__*/_react.default.createElement(_block_disable_overlay.BlockDisableOverlay, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 65
    }
  }), isUnderEdit ? /*#__PURE__*/_react.default.createElement(_configuration.WhereBlockConfiguration, {
    stepRef: stepRef,
    ref: freshBlockRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, hasChildren ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react3.css)`
                      margin-left: -${euiTheme.size.xxs};
                    `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    onClick: toggle,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.toggleNestedStepsButtonAriaLabel', {
      defaultMessage: 'Toggle nested steps'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 21
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem
  // Overflow is here to faciliate text truncation of long conditions in the summary
  , {
    css: (0, _react3.css)`
                    overflow: hidden;
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_summary.WhereBlockSummary, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 19
    }
  }))))), hasChildren && !isExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: nestedSummaryPanelColour,
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_nested_children_processing_summary.NestedChildrenProcessingSummary, {
    childIds: descendantIds,
    stepsProcessingSummaryMap: stepsProcessingSummaryMap,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 19
    }
  })))), hasChildren && isExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_connected_nodes_list.ConnectedNodesList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, childSteps.map((childStep, index) => /*#__PURE__*/_react.default.createElement("li", {
    key: childStep.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_steps_list.StepsListItem, {
    stepRef: childStep,
    level: level + 1,
    stepUnderEdit: stepUnderEdit,
    rootLevelMap: rootLevelMap,
    stepsProcessingSummaryMap: stepsProcessingSummaryMap,
    isFirstStepInLevel: index === 0,
    isLastStepInLevel: index === childSteps.length - 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 19
    }
  })))))));
};
exports.WhereBlock = WhereBlock;