"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepContextMenu = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _react2 = require("@xstate5/react");
var _streamlang = require("@kbn/streamlang");
var _use_discard_confirm = require("../../../../../hooks/use_discard_confirm");
var _stream_enrichment_state_machine = require("../../state_management/stream_enrichment_state_machine");
var _prompt_options = require("./action/prompt_options");
var _prompt_options2 = require("./where/prompt_options");
var _utils = require("../../state_management/stream_enrichment_state_machine/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const moveUpItemText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.moveUpItemButtonText', {
  defaultMessage: 'Move up'
});
const moveDownItemText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.moveDownItemButtonText', {
  defaultMessage: 'Move down'
});
const editItemText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.editItemButtonText', {
  defaultMessage: 'Edit item'
});
const deleteItemText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.deleteItemButtonText', {
  defaultMessage: 'Delete'
});
const StepContextMenu = ({
  stepRef,
  stepUnderEdit,
  isFirstStepInLevel,
  isLastStepInLevel
}) => {
  const {
    reorderStep
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const canEdit = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.can({
    type: 'step.edit'
  }));
  const canReorder = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.can({
    type: 'step.reorder',
    stepId: stepRef.id,
    direction: 'up'
  }) || snapshot.can({
    type: 'step.reorder',
    stepId: stepRef.id,
    direction: 'down'
  }));
  const canDelete = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.can({
    type: 'step.delete',
    id: stepRef.id
  }));
  const stepRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.context.stepRefs);
  const step = (0, _react2.useSelector)(stepRef, snapshot => snapshot.context.step);
  const isWhere = (0, _streamlang.isWhereBlock)(step);
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const menuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'stepContextMenuPopover'
  });
  const handleEdit = () => {
    stepRef.send({
      type: 'step.edit'
    });
  };
  const getChildStepsLength = () => {
    return !isWhere ? 0 : (0, _utils.collectDescendantIds)(step.customIdentifier, stepRefs).size;
  };
  const deletePromptOptions = !isWhere ? _prompt_options.deleteProcessorPromptOptions : {
    ..._prompt_options2.deleteConditionPromptOptions,
    message: _i18n.i18n.translate('xpack.streams.enrichment.condition.deleteCondition.message', {
      defaultMessage: 'If you delete this condition, you will also remove the {childCount} {childCount, plural, one {child} other {children}} in it. Are you sure you want to remove this?',
      values: {
        childCount: getChildStepsLength()
      }
    })
  };
  const handleDelete = (0, _use_discard_confirm.useDiscardConfirm)(() => stepRef.send({
    type: 'step.delete'
  }), {
    enabled: canDelete,
    ...deletePromptOptions
  });
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "stepContextMenuMoveUpItem",
    key: "moveUpItem",
    icon: "arrowUp",
    disabled: !canReorder || isFirstStepInLevel,
    onClick: () => {
      togglePopover(false);
      reorderStep(stepRef.id, 'up');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, moveUpItemText), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "stepContextMenuMoveDownItem",
    key: "moveDownItem",
    icon: "arrowDown",
    disabled: !canReorder || isLastStepInLevel,
    onClick: () => {
      togglePopover(false);
      reorderStep(stepRef.id, 'down');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, moveDownItemText), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "stepContextMenuEditItem",
    key: "editItem",
    icon: "pencil",
    disabled: !canEdit,
    onClick: () => {
      togglePopover(false);
      handleEdit();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, editItemText), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "stepContextMenuDeleteItem",
    key: "deleteStep",
    icon: "trash",
    disabled: !canDelete,
    onClick: () => {
      togglePopover(false);
      handleDelete();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, deleteItemText)];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.stepContextMenuButtonAriaLabel', {
      defaultMessage: 'Step context menu'
    }),
    "data-test-subj": "streamsAppStreamDetailEnrichmentStepContextMenuButton",
    disabled: !!stepUnderEdit,
    size: "xs",
    iconType: "boxesVertical",
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: menuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => togglePopover(false),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }));
};
exports.StepContextMenu = StepContextMenu;