"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _field_selector = require("../../../../shared/field_selector");
var _use_field_suggestions = require("../../../../../../hooks/use_field_suggestions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/processor_field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProcessorFieldSelector = ({
  fieldKey = 'from',
  helpText,
  placeholder,
  label,
  onChange
}) => {
  var _fieldState$error;
  const suggestions = (0, _use_field_suggestions.useEnrichmentFieldSuggestions)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: fieldKey,
    rules: {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorRequiredError', {
        defaultMessage: 'A field value is required.'
      })
    }
  });
  const handleChange = (0, _react.useCallback)(value => {
    field.onChange(value);
    onChange === null || onChange === void 0 ? void 0 : onChange(value);
  }, [field, onChange]);
  const defaultLabel = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorSourceLabel', {
    defaultMessage: 'Source Field'
  });
  const defaultHelpText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorSourceHelpText', {
    defaultMessage: 'Select or enter a field name'
  });
  const defaultPlaceholder = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorPlaceholder', {
    defaultMessage: 'Select or type a field name...'
  });
  return /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    value: field.value,
    onChange: handleChange,
    label: label !== null && label !== void 0 ? label : defaultLabel,
    helpText: helpText !== null && helpText !== void 0 ? helpText : defaultHelpText,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : defaultPlaceholder,
    suggestions: suggestions,
    fullWidth: true,
    dataTestSubj: "streamsAppProcessorFieldSelectorComboFieldText",
    isInvalid: fieldState.invalid,
    error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
};
exports.ProcessorFieldSelector = ProcessorFieldSelector;