"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokPatternAISuggestions = void 0;
exports.GrokPatternSuggestion = GrokPatternSuggestion;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _grokUi = require("@kbn/grok-ui");
var _reactHookForm = require("react-hook-form");
var _use_stream_detail = require("../../../../../../../hooks/use_stream_detail");
var _selectors = require("../../../../state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("../../../../state_management/stream_enrichment_state_machine");
var _additional_charges_callout = require("./additional_charges_callout");
var _generate_suggestions_button = require("../../../../../stream_detail_routing/review_suggestions_form/generate_suggestions_button");
var _use_grok_pattern_suggestion = require("./use_grok_pattern_suggestion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/grok/grok_pattern_suggestion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GrokPatternAISuggestions = ({
  aiFeatures,
  grokCollection,
  setValue,
  onAddPattern
}) => {
  const {
    definition: {
      stream
    }
  } = (0, _use_stream_detail.useStreamDetail)();
  const previewDocuments = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectPreviewRecords)(snapshot.context));
  const [suggestionsState, refreshSuggestions] = (0, _use_grok_pattern_suggestion.useGrokPatternSuggestion)();
  const fieldValue = (0, _reactHookForm.useWatch)({
    name: 'from'
  });
  const isValidField = (0, _react.useMemo)(() => {
    return Boolean(fieldValue && previewDocuments.some(sample => sample[fieldValue] && typeof sample[fieldValue] === 'string'));
  }, [previewDocuments, fieldValue]);
  if (suggestionsState.value) {
    return /*#__PURE__*/_react.default.createElement(GrokPatternSuggestion, {
      grokProcessor: suggestionsState.value.grokProcessor,
      simulationResult: suggestionsState.value.simulationResult,
      onAccept: () => {
        if (suggestionsState.value) {
          setValue('patterns', suggestionsState.value.grokProcessor.patterns.map(value => new _grokUi.DraftGrokExpression(grokCollection, value)), {
            shouldValidate: true
          });
        }
        refreshSuggestions(null);
      },
      onDismiss: () => refreshSuggestions(null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, aiFeatures.enabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_generate_suggestions_button.GenerateSuggestionButton, {
    aiFeatures: aiFeatures,
    onClick: connectorId => {
      refreshSuggestions({
        connectorId,
        streamName: stream.name,
        fieldName: fieldValue
      });
    },
    isLoading: suggestionsState.loading,
    isDisabled: !isValidField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.refreshSuggestions', {
    defaultMessage: 'Generate pattern'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppGrokPatternsEditorAddPatternButton",
    flush: "left",
    size: "s",
    onClick: onAddPattern,
    isDisabled: suggestionsState.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.addPattern', {
    defaultMessage: 'Add pattern'
  })))), aiFeatures && aiFeatures.isManagedAIConnector && !aiFeatures.hasAcknowledgedAdditionalCharges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_additional_charges_callout.AdditionalChargesCallout, {
    aiFeatures: aiFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  })));
};
exports.GrokPatternAISuggestions = GrokPatternAISuggestions;
function GrokPatternSuggestion({
  grokProcessor,
  simulationResult,
  onAccept,
  onDismiss
}) {
  const processorMetrics = simulationResult.processors_metrics['grok-processor'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "sparkles",
    title: grokProcessor.description,
    color: "primary",
    size: "s",
    onDismiss: onDismiss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, grokProcessor.patterns.map((pattern, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    key: pattern,
    paddingSize: "none",
    language: "regex",
    transparentBackground: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, pattern)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: false,
    alignItems: "flexStart",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.grokPatternSuggestion.matchRateBadge', {
    defaultMessage: '{percentage}% Matched',
    values: {
      percentage: (processorMetrics.parsed_rate * 100).toFixed()
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.grokPatternSuggestion.fieldCountBadge', {
    defaultMessage: '{count} Fields',
    values: {
      count: processorMetrics.detected_fields.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "check",
    onClick: onAccept,
    color: "primary",
    size: "s",
    fill: true,
    "data-test-subj": "streamsAppGrokSuggestionAcceptButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.grokPatternSuggestion.acceptButton', {
    defaultMessage: 'Accept'
  })))));
}