"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSimulationRunFailureNotifier = createSimulationRunFailureNotifier;
exports.createSimulationRunnerActor = createSimulationRunnerActor;
exports.simulateProcessing = void 0;
var _i18n = require("@kbn/i18n");
var _xstate = require("xstate5");
var _lodash = require("lodash");
var _streamlang = require("@kbn/streamlang");
var _errors = require("../../../../../util/errors");
var _utils = require("./utils");
var _utils2 = require("../../../schema_editor/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createSimulationRunnerActor({
  streamsRepositoryClient
}) {
  return (0, _xstate.fromPromise)(({
    input,
    signal
  }) => simulateProcessing({
    streamsRepositoryClient,
    input,
    signal
  }));
}
const simulateProcessing = ({
  streamsRepositoryClient,
  input,
  signal = null
}) => {
  const dsl = (0, _streamlang.convertUIStepsToDSL)(input.steps, false);
  return streamsRepositoryClient.fetch('POST /internal/streams/{name}/processing/_simulate', {
    signal,
    params: {
      path: {
        name: input.streamName
      },
      body: {
        documents: input.documents,
        processing: dsl,
        detected_fields: input.detectedFields && !(0, _lodash.isEmpty)(input.detectedFields) ? (0, _utils.getMappedSchemaFields)(input.detectedFields).map(field => ({
          name: field.name,
          ...(0, _utils2.convertToFieldDefinitionConfig)(field)
        })) : undefined
      }
    }
  });
};
exports.simulateProcessing = simulateProcessing;
function createSimulationRunFailureNotifier({
  toasts
}) {
  return params => {
    const event = params.event;
    const formattedError = (0, _errors.getFormattedError)(event.error);
    toasts.addError(formattedError, {
      title: _i18n.i18n.translate('xpack.streams.enrichment.simulation.simulationRunError', {
        defaultMessage: 'An issue occurred running the simulation.'
      }),
      toastMessage: formattedError.message
    });
  };
}