"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocViewerContext = exports.docViewDiff = exports.DocViewerContext = exports.DOC_VIEW_DIFF_ID = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _objectUtils = require("@kbn/object-utils");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _get_height = require("./get_height");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/doc_viewer_diff.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocViewerContext = exports.DocViewerContext = /*#__PURE__*/_react.default.createContext({});
const useDocViewerContext = () => {
  const context = _react.default.useContext(DocViewerContext);
  if (!context) {
    throw new Error('DocViewerContext must be used within a DocViewerContext.Provider');
  }
  return context;
};
exports.useDocViewerContext = useDocViewerContext;
function orderObjectKeys(obj) {
  if (Array.isArray(obj)) {
    return obj.map(orderObjectKeys);
  } else if (obj && typeof obj === 'object') {
    return Object.keys(obj).sort().reduce((acc, key) => {
      acc[key] = orderObjectKeys(obj[key]);
      return acc;
    }, {});
  }
  return obj;
}
const DOC_VIEW_DIFF_ID = exports.DOC_VIEW_DIFF_ID = 'doc_view_diff';
const docViewDiff = exports.docViewDiff = {
  id: DOC_VIEW_DIFF_ID,
  title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.docViews.diff.diffTitle', {
    defaultMessage: 'Diff viewer'
  }),
  order: 15,
  component: JsonDiffViewer
};
function JsonDiffViewer({
  hit,
  decreaseAvailableHeightBy
}) {
  const wrapperRef = (0, _react.useRef)(null);
  const euiTheme = (0, _eui.useEuiTheme)();
  const [editorHeight, setEditorHeight] = (0, _react.useState)(0);
  const {
    originalSample
  } = useDocViewerContext();
  const originalValue = (0, _react.useMemo)(() => originalSample && JSON.stringify(orderObjectKeys((0, _objectUtils.flattenObjectNestedLast)(originalSample)), null, 2), [originalSample]);
  const newValue = (0, _react.useMemo)(() => JSON.stringify(orderObjectKeys(hit.flattened), null, 2), [hit.flattened]);

  // compute height based on wrapper container
  (0, _react.useEffect)(() => {
    if (!wrapperRef.current) return;
    const height = (0, _get_height.getTabContentAvailableHeight)(wrapperRef.current, decreaseAvailableHeightBy !== null && decreaseAvailableHeightBy !== void 0 ? decreaseAvailableHeightBy : _get_height.DEFAULT_MARGIN_BOTTOM);
    setEditorHeight(height);
  }, [decreaseAvailableHeightBy]);
  const editorRef = (0, _react.useRef)(null);
  (0, _react.useLayoutEffect)(() => {
    if (!wrapperRef.current) return;
    const oldModel = _monaco.monaco.editor.createModel(originalValue || '', _monaco.XJsonLang.ID);
    const newModel = _monaco.monaco.editor.createModel(newValue, _monaco.XJsonLang.ID);
    if (!editorRef.current) {
      editorRef.current = _monaco.monaco.editor.createDiffEditor(wrapperRef.current, {
        automaticLayout: true,
        theme: _monaco.CODE_EDITOR_DEFAULT_THEME_ID
      });
    }
    editorRef.current.setModel({
      original: oldModel,
      modified: newModel
    });
    const commonOptions = {
      lightbulb: {
        enabled: false
      },
      fontSize: 12,
      lineNumbers: 'off',
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      readOnly: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false,
        useShadows: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      renderLineHighlight: 'none',
      matchBrackets: 'never',
      fontFamily: 'Roboto Mono',
      lineHeight: 21,
      contextmenu: false,
      // @ts-expect-error, see https://github.com/microsoft/monaco-editor/issues/3829
      'bracketPairColorization.enabled': false
    };
    editorRef.current.updateOptions({
      ...commonOptions,
      renderSideBySide: false
    });
    editorRef.current.getOriginalEditor().updateOptions(commonOptions);
    editorRef.current.getModifiedEditor().updateOptions(commonOptions);
  }, [originalValue, newValue, editorHeight]);
  (0, _react.useEffect)(() => {
    // register default theme code editor theme
    Object.entries(_monaco.defaultThemesResolvers).forEach(([themeId, themeResolver]) => {
      _monaco.monaco.editor.defineTheme(themeId, themeResolver(euiTheme));
    });

    // register theme configurations for supported languages
    _monaco.monaco.languages.getLanguages().forEach(({
      id: languageId
    }) => {
      let languageThemeResolver;
      if (Boolean(languageThemeResolver = _monaco.monaco.editor.getLanguageThemeResolver(languageId))) {
        _monaco.monaco.editor.defineTheme(languageId, languageThemeResolver(euiTheme));
      }
    });
  }, [euiTheme]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: wrapperRef,
    className: (0, _css.css)`
        width: 100%;
        height: ${editorHeight}px;
        // https://github.com/microsoft/monaco-editor/issues/3873
        .codicon-light-bulb {
          display: none !important;
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  });
}