"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KqlSamplesDataSourceCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _data_source_state_machine = require("../state_management/data_source_state_machine");
var _uncontrolled_streams_app_bar = require("../../../streams_app_search_bar/uncontrolled_streams_app_bar");
var _data_source_card = require("./data_source_card");
var _name_field = require("./name_field");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_flyout/kql_samples_data_source_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KqlSamplesDataSourceCard = ({
  dataSourceRef
}) => {
  const {
    data
  } = (0, _use_kibana.useKibana)().dependencies.start;
  const definition = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition);
  const dataSource = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot.context.dataSource);
  const isDisabled = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot.matches('disabled'));
  const {
    value: streamDataView
  } = (0, _useAsync.default)(() => data.dataViews.create({
    title: definition.stream.name,
    timeFieldName: '@timestamp'
  }));
  const handleChange = params => {
    dataSourceRef.send({
      type: 'dataSource.change',
      dataSource: {
        ...dataSource,
        ...params
      }
    });
  };
  const handleQueryChange = ({
    query,
    dateRange
  }) => handleChange({
    query: query,
    timeRange: dateRange
  });
  const dateFilterProps = dataSource.timeRange ? {
    showDatePicker: true,
    dataRangeFrom: dataSource.timeRange.from,
    dataRangeTo: dataSource.timeRange.to
  } : {};
  return /*#__PURE__*/_react.default.createElement(_data_source_card.DataSourceCard, {
    dataSourceRef: dataSourceRef,
    title: _translations.DATA_SOURCES_I18N.kqlDataSource.defaultName,
    subtitle: _translations.DATA_SOURCES_I18N.kqlDataSource.subtitle,
    isPreviewVisible: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_name_field.NameField, {
    onChange: event => handleChange({
      name: event.target.value
    }),
    value: dataSource.name,
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), streamDataView && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_uncontrolled_streams_app_bar.UncontrolledStreamsAppSearchBar, (0, _extends2.default)({
    filters: dataSource.filters,
    indexPatterns: [streamDataView],
    isDisabled: isDisabled,
    onFiltersUpdated: filters => handleChange({
      filters
    }),
    onQuerySubmit: handleQueryChange,
    query: dataSource.query,
    showFilterBar: true,
    showQueryInput: true
  }, dateFilterProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  })));
};
exports.KqlSamplesDataSourceCard = KqlSamplesDataSourceCard;