"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatusFilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _filter_group = require("./filter_group");
var _constants = require("../constants");
var _schema_editor_context = require("../schema_editor_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/filters/status_filter_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.fieldStatusFilterGroupButtonLabel', {
  defaultMessage: 'Status'
});
const FieldStatusFilterGroup = ({
  onChange
}) => {
  const {
    fields
  } = (0, _schema_editor_context.useSchemaEditorContext)();
  const fieldStatus = (0, _react.useMemo)(() => (0, _lodash.uniq)(fields.map(field => field.status)), [fields]);
  const [items, setItems] = (0, _react.useState)(() => getStatusOptions(fieldStatus));

  // This side effect is due to the fact that the available field status can be updated once the unmapped fields are fetched.
  (0, _react.useEffect)(() => {
    setItems(prevItems => {
      const prevSelection = new Map(prevItems.map(item => [item.key, item.checked]));
      const nextItems = getStatusOptions(fieldStatus);
      nextItems.forEach(item => {
        if (prevSelection.has(item.key)) {
          item.checked = prevSelection.get(item.key);
        }
      });
      return nextItems;
    });
  }, [fieldStatus]);
  const onChangeItems = (0, _react.useCallback)(nextItems => {
    setItems(nextItems);
    onChange({
      status: nextItems.filter(nextItem => nextItem.checked === 'on').map(item => item.key)
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    items: items,
    filterGroupButtonLabel: BUTTON_LABEL,
    onChange: onChangeItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
};
exports.FieldStatusFilterGroup = FieldStatusFilterGroup;
const getStatusOptions = fieldStatus => {
  return fieldStatus.map(key => ({
    label: _constants.FIELD_STATUS_MAP[key].label,
    key
  }));
};