"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldType = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/field_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldType = ({
  type,
  aliasFor
}) => {
  if (aliasFor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenAlias",
      "aria-label": "alias",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.fieldType.aliasFor', {
      defaultMessage: 'Alias for {aliasFor}',
      values: {
        aliasFor
      }
    })));
  }

  // Handle unknown types gracefully - if type is not in FIELD_TYPE_MAP, show the type name directly
  // for eg. object, nested, geo_point, binary, etc
  const typeInfo = _constants.FIELD_TYPE_MAP[type];
  if (!typeInfo) {
    return /*#__PURE__*/_react.default.createElement(_reactField.FieldNameWithIcon, {
      name: type,
      type: type !== 'system' ? type : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldNameWithIcon, {
    name: typeInfo.label,
    type: type !== 'system' ? type : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 10
    }
  });
};
exports.FieldType = FieldType;