"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamTree = StreamTree;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _streamsSchema = require("@kbn/streams-schema");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/content/objects_list/tree.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamTree({
  streams,
  onSelectionChange
}) {
  const [rows, setRows] = _react.default.useState(streams.sort((a, b) => a.name.localeCompare(b.name)).reduce((map, stream, index, sorted) => {
    const next = sorted[index + 1];
    map[stream.name] = {
      name: stream.name,
      expanded: true,
      selected: true,
      parent: !!(next && (0, _streamsSchema.isDescendantOf)(stream.name, next.name))
    };
    return map;
  }, {}));
  const sortedRows = _react.default.useMemo(() => {
    return Object.values(rows).filter(({
      name
    }) => (0, _streamsSchema.getAncestors)(name).every(ancestor => rows[ancestor].expanded));
  }, [rows]);
  const hasDepth = _react.default.useMemo(() => Object.values(rows).some(row => (0, _streamsSchema.getSegments)(row.name).length > 1), [rows]);
  const selectedCount = Object.values(rows).filter(({
    selected
  }) => selected).length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "s",
    hasShadow: false,
    hasBorder: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.contentPackObjectsList.selectStreamsPartitions', {
    defaultMessage: 'Select streams partitions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, selectedCount === Object.values(rows).length ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setRows(prevRows => {
        const updated = {
          ...prevRows
        };
        Object.keys(updated).forEach(key => {
          updated[key].selected = false;
        });
        onSelectionChange(updated);
        return updated;
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.contentPackObjectsList.unselectAll', {
    defaultMessage: 'Unselect all'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setRows(prevRows => {
        const updated = {
          ...prevRows
        };
        Object.keys(updated).forEach(key => {
          updated[key].selected = true;
        });
        onSelectionChange(updated);
        return updated;
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.contentPackObjectsList.selectAll', {
    defaultMessage: 'Select all'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, selectedCount, "/", Object.values(rows).length, " selected")))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), sortedRows.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: item.name,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      css: (0, _react2.css)`
                margin-left: ${((0, _streamsSchema.getSegments)(item.name).length - 1) * 28}px;
              `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    }, item.parent ? item.expanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.streams.contentPack.tree.collapse', {
        defaultMessage: 'Collapse'
      }),
      iconType: "arrowDown",
      color: "text",
      onClick: () => {
        setRows(prevRows => {
          const updated = {
            ...prevRows
          };
          updated[item.name].expanded = false;
          onSelectionChange(updated);
          return updated;
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 21
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.streams.contentPack.tree.expand', {
        defaultMessage: 'Expand'
      }),
      iconType: "arrowRight",
      color: "text",
      onClick: () => {
        setRows(prevRows => {
          const updated = {
            ...prevRows
          };
          updated[item.name].expanded = true;
          onSelectionChange(updated);
          return updated;
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 21
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: hasDepth ? (0, _react2.css)`
                          margin-left: 24px;
                          height: 24px;
                        ` : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `checkbox-${item.name}`,
      checked: item.selected,
      indeterminate: item.selected && item.parent && !allDescendantsSelected(item.name, rows),
      label: item.name,
      onChange: e => {
        const selection = {
          ...rows
        };
        if (e.target.checked) {
          [...(0, _streamsSchema.getAncestorsAndSelf)(item.name), ...streams.filter(({
            name
          }) => (0, _streamsSchema.isDescendantOf)(item.name, name)).map(({
            name
          }) => name)].forEach(name => {
            selection[name] = {
              ...selection[name],
              selected: true,
              expanded: true
            };
          });
        } else {
          [item.name, ...streams.filter(({
            name
          }) => (0, _streamsSchema.isDescendantOf)(item.name, name)).map(({
            name
          }) => name)].forEach(name => {
            selection[name] = {
              ...selection[name],
              selected: false
            };
          });
          (0, _streamsSchema.getAncestors)(item.name).forEach(ancestor => {
            const hasSelectedChild = streams.some(({
              name
            }) => (0, _streamsSchema.isDescendantOf)(ancestor, name) && selection[name].selected);
            selection[ancestor] = {
              ...selection[ancestor],
              selected: hasSelectedChild
            };
          });
        }
        setRows(selection);
        onSelectionChange(selection);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    })), index === sortedRows.length - 1 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 55
      }
    }));
  }));
}
function allDescendantsSelected(parent, rows) {
  return Object.values(rows).filter(({
    name
  }) => (0, _streamsSchema.isDescendantOf)(parent, name)).every(({
    selected
  }) => selected);
}