"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateStreamDescription = generateStreamDescription;
var _aiTools = require("@kbn/ai-tools");
var _streamlang = require("@kbn/streamlang");
var _prompt = require("./prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generate a natural-language description
 */
async function generateStreamDescription({
  stream,
  feature,
  start,
  end,
  esClient,
  inferenceClient
}) {
  const analysis = await (0, _aiTools.describeDataset)({
    start,
    end,
    esClient,
    index: stream.name,
    filter: feature ? (0, _streamlang.conditionToQueryDsl)(feature.filter) : undefined
  });
  const response = await inferenceClient.prompt({
    input: {
      name: (feature === null || feature === void 0 ? void 0 : feature.name) || stream.name,
      dataset_analysis: JSON.stringify((0, _aiTools.sortAndTruncateAnalyzedFields)(analysis, {
        dropEmpty: true,
        dropUnmapped: false
      }))
    },
    prompt: _prompt.GenerateStreamDescriptionPrompt
  });
  return response.content;
}