"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/thehive/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: _constants.THEHIVE_CONNECTOR_ID,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.descriptionText', {
      defaultMessage: 'Create cases and alerts in TheHive'
    }),
    actionTypeTitle: _constants.THEHIVE_TITLE,
    validateParams: async actionParams => {
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        'pushToServiceParam.incident.title': new Array(),
        'pushToServiceParam.incident.description': new Array(),
        'createAlertParam.title': new Array(),
        'createAlertParam.description': new Array(),
        'createAlertParam.type': new Array(),
        'createAlertParam.source': new Array(),
        'createAlertParam.sourceRef': new Array()
      };
      const validationResult = {
        errors
      };
      const {
        subAction,
        subActionParams
      } = actionParams;
      if (subAction === _constants.SUB_ACTION.PUSH_TO_SERVICE) {
        const pushToServiceParam = subActionParams;
        if (pushToServiceParam && pushToServiceParam.incident) {
          var _pushToServiceParam$i, _pushToServiceParam$i2;
          if (!((_pushToServiceParam$i = pushToServiceParam.incident.title) !== null && _pushToServiceParam$i !== void 0 && _pushToServiceParam$i.length)) {
            errors['pushToServiceParam.incident.title'].push(translations.TITLE_REQUIRED);
          }
          if (!((_pushToServiceParam$i2 = pushToServiceParam.incident.description) !== null && _pushToServiceParam$i2 !== void 0 && _pushToServiceParam$i2.length)) {
            errors['pushToServiceParam.incident.description'].push(translations.DESCRIPTION_REQUIRED);
          }
        }
      } else if (subAction === _constants.SUB_ACTION.CREATE_ALERT) {
        const createAlertParam = subActionParams;
        if (createAlertParam) {
          var _createAlertParam$tit, _createAlertParam$des, _createAlertParam$typ, _createAlertParam$sou, _createAlertParam$sou2;
          if (!((_createAlertParam$tit = createAlertParam.title) !== null && _createAlertParam$tit !== void 0 && _createAlertParam$tit.length)) {
            errors['createAlertParam.title'].push(translations.TITLE_REQUIRED);
          }
          if (!((_createAlertParam$des = createAlertParam.description) !== null && _createAlertParam$des !== void 0 && _createAlertParam$des.length)) {
            errors['createAlertParam.description'].push(translations.DESCRIPTION_REQUIRED);
          }
          if (!((_createAlertParam$typ = createAlertParam.type) !== null && _createAlertParam$typ !== void 0 && _createAlertParam$typ.length)) {
            errors['createAlertParam.type'].push(translations.TYPE_REQUIRED);
          }
          if (!((_createAlertParam$sou = createAlertParam.source) !== null && _createAlertParam$sou !== void 0 && _createAlertParam$sou.length)) {
            errors['createAlertParam.source'].push(translations.SOURCE_REQUIRED);
          }
          if (!((_createAlertParam$sou2 = createAlertParam.sourceRef) !== null && _createAlertParam$sou2 !== void 0 && _createAlertParam$sou2.length)) {
            errors['createAlertParam.sourceRef'].push(translations.SOURCE_REF_REQUIRED);
          }
        }
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./params'))))
  };
}