"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEBHOOK_URL_LABEL = exports.WEBHOOK_URL_INVALID = exports.WEBHOOK_DEPRECATION_WARNING = exports.MESSAGE_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WEBHOOK_URL_LABEL = exports.WEBHOOK_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.teams.error.webhookUrlTextLabel', {
  defaultMessage: 'Webhook URL'
});
const WEBHOOK_URL_INVALID = exports.WEBHOOK_URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.teams.error.invalidWebhookUrlText', {
  defaultMessage: 'Webhook URL is invalid.'
});
const MESSAGE_REQUIRED = exports.MESSAGE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.teams.error.requiredMessageText', {
  defaultMessage: 'Message is required.'
});
const WEBHOOK_DEPRECATION_WARNING = exports.WEBHOOK_DEPRECATION_WARNING = _i18n.i18n.translate('xpack.stackConnectors.components.teams.warning.webhookDeprecation', {
  defaultMessage: 'Microsoft Teams deprecated some methods for configuring webhooks. Follow the documentation link to create a supported webhook URL. If the URL is not updated by December 31, 2025, notifications will stop.'
});