"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
exports.subtype = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/slack/constants");
var _constants2 = require("../../../common/slack_api/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const subtype = exports.subtype = [{
  id: _constants.SLACK_CONNECTOR_ID,
  name: _i18n.i18n.translate('xpack.stackConnectors.components.slack.webhook', {
    defaultMessage: 'Webhook'
  })
}, {
  id: _constants2.SLACK_API_CONNECTOR_ID,
  name: _i18n.i18n.translate('xpack.stackConnectors.components.slack.webApi', {
    defaultMessage: 'Web API'
  })
}];
function getConnectorType() {
  return {
    id: _constants.SLACK_CONNECTOR_ID,
    subtype,
    modalWidth: 675,
    iconClass: 'logoSlack',
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.slack.selectMessageText', {
      defaultMessage: 'Send messages to Slack channels.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.slack.connectorTypeTitle', {
      defaultMessage: 'Slack'
    }),
    validateParams: async actionParams => {
      var _actionParams$message;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        message: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$message = actionParams.message) !== null && _actionParams$message !== void 0 && _actionParams$message.length)) {
        errors.message.push(translations.MESSAGE_REQUIRED);
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./slack_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./slack_params')))),
    convertParamsBetweenGroups: params => {
      if ('message' in params) {
        return params;
      } else if ('subAction' in params) {
        return {
          message: params.subActionParams.text
        };
      }
      return {};
    }
  };
}