"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("../lib/servicenow/translations"));
var _use_choices = require("../lib/servicenow/use_choices");
var _helpers = require("../lib/servicenow/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/servicenow_itom/servicenow_itom_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const choicesFields = ['severity'];
const fields = [{
  label: i18n.SOURCE,
  fieldKey: 'source'
}, {
  label: i18n.NODE,
  fieldKey: 'node'
}, {
  label: i18n.TYPE,
  fieldKey: 'type'
}, {
  label: i18n.RESOURCE,
  fieldKey: 'resource'
}, {
  label: i18n.METRIC_NAME,
  fieldKey: 'metric_name'
}, {
  label: i18n.EVENT_CLASS,
  fieldKey: 'event_class'
}, {
  label: i18n.MESSAGE_KEY,
  fieldKey: 'message_key'
}];
const additionalInformation = JSON.stringify({
  alert: {
    id: '{{alert.id}}',
    actionGroup: '{{alert.actionGroup}}',
    actionSubgroup: '{{alert.actionSubgroup}}',
    actionGroupName: '{{alert.actionGroupName}}'
  },
  rule: {
    id: '{{rule.id}}',
    name: '{{rule.name}}',
    type: '{{rule.type}}'
  },
  date: '{{date}}'
}, null, 4);
const ServiceNowITOMParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  var _actionConnector$id;
  const params = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {};
  }, [actionParams.subActionParams]);
  const {
    description,
    severity,
    additional_info: additionalInfo
  } = params;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const {
    choices,
    isLoading: isLoadingChoices
  } = (0, _use_choices.useChoices)({
    http,
    toastNotifications: toasts,
    actionConnector,
    fields: choicesFields
  });
  const severityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.severity), [choices.severity]);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    editAction('subActionParams', {
      ...params,
      [key]: value
    }, index);
  }, [editAction, index, params]);
  (0, _react.useEffect)(() => {
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      editAction('subActionParams', {
        additional_info: additionalInformation,
        message_key: '{{rule.id}}:{{alert.id}}'
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', 'addEvent', index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        additional_info: additionalInformation,
        message_key: '{{rule.id}}:{{alert.id}}'
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, i18n.EVENT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), fields.map(field => {
    var _params$field$fieldKe;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: field.fieldKey,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: field.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
      index: index,
      editAction: editSubActionProperty,
      messageVariables: messageVariables,
      paramsProperty: field.fieldKey,
      inputTargetValue: (_params$field$fieldKe = params[field.fieldKey]) !== null && _params$field$fieldKe !== void 0 ? _params$field$fieldKe : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SEVERITY_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }, i18n.REQUIRED_LABEL),
    error: errors.severity,
    isInvalid: (0, _helpers.isFieldInvalid)(severity, errors.severity),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    hasNoInitialSelection: true,
    "data-test-subj": "severitySelect",
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: severityOptions,
    value: severity !== null && severity !== void 0 ? severity : '',
    onChange: e => editSubActionProperty('severity', e.target.value),
    isInvalid: (0, _helpers.isFieldInvalid)(severity, errors.severity),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: description !== null && description !== void 0 ? description : undefined,
    label: i18n.DESCRIPTION_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors['subActionParams.additional_info'],
    isInvalid: errors['subActionParams.additional_info'] !== undefined && Number(errors['subActionParams.additional_info'].length) > 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'additional_info',
    inputTargetValue: additionalInfo !== null && additionalInfo !== void 0 ? additionalInfo : '',
    errors: errors.additional_info,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ADDITIONAL_INFO, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      "data-test-subj": "otherFieldsHelpTooltip",
      "aria-label": i18n.ADDITIONAL_INFO_HELP,
      content: i18n.ADDITIONAL_FIELDS_HELP_SERVICENOW_TEXT,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    })),
    onDocumentsChange: json => {
      editSubActionProperty('additional_info', json);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = ServiceNowITOMParamsFields;
module.exports = exports.default;