"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
var _create_alert = require("./create_alert");
var _close_alert = require("./close_alert");
var _close_alert_schema = require("./close_alert_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/opsgenie/params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const actionOptions = [{
  value: _common.OpsgenieSubActions.CreateAlert,
  text: i18n.CREATE_ALERT_ACTION,
  'data-test-subj': 'opsgenie-subActionSelect-create-alert'
}, {
  value: _common.OpsgenieSubActions.CloseAlert,
  text: i18n.CLOSE_ALERT_ACTION,
  'data-test-subj': 'opsgenie-subActionSelect-close-alert'
}];
const OpsgenieParamFields = ({
  actionParams,
  editAction,
  errors,
  index,
  messageVariables,
  executionMode
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const currentSubAction = (0, _react.useRef)(subAction !== null && subAction !== void 0 ? subAction : _common.OpsgenieSubActions.CreateAlert);
  const onActionChange = (0, _react.useCallback)(event => {
    editAction('subAction', event.target.value, index);
  }, [editAction, index]);
  const editOptionalSubAction = (0, _react.useCallback)((key, value) => {
    if ((0, _lodash.isEmpty)(value)) {
      const paramsCopy = (0, _lodash.cloneDeep)(subActionParams);
      (0, _lodash.unset)(paramsCopy, key);
      editAction('subActionParams', paramsCopy, index);
      return;
    }
    editAction('subActionParams', {
      ...subActionParams,
      [key]: value
    }, index);
  }, [editAction, index, subActionParams]);
  const editSubAction = (0, _react.useCallback)((key, value) => {
    editAction('subActionParams', {
      ...subActionParams,
      [key]: value
    }, index);
  }, [editAction, index, subActionParams]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', _common.OpsgenieSubActions.CreateAlert, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [index, subAction]);
  (0, _react.useEffect)(() => {
    if (subAction != null && currentSubAction.current !== subAction) {
      currentSubAction.current = subAction;

      // check for a mismatch in the subAction and params, if the subAction does not match the params then we need to
      // clear them by calling editAction. We can carry over the alias if it exists
      if (subAction === _common.OpsgenieSubActions.CreateAlert && !(0, _create_alert.isPartialCreateAlertSchema)(subActionParams) || subAction === _common.OpsgenieSubActions.CloseAlert && !(0, _close_alert_schema.isPartialCloseAlertSchema)(subActionParams)) {
        const params = subActionParams !== null && subActionParams !== void 0 && subActionParams.alias ? {
          alias: subActionParams.alias
        } : undefined;
        editAction('subActionParams', params, index);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [subAction, currentSubAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, executionMode === _public.ActionConnectorMode.Test && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.ACTION_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "opsgenie-subActionSelect",
    options: actionOptions,
    hasNoInitialSelection: subAction == null,
    value: subAction,
    onChange: onActionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })), subAction === _common.OpsgenieSubActions.CreateAlert && /*#__PURE__*/_react.default.createElement(_create_alert.CreateAlert, {
    showSaveError: showCreateAlertSaveError(actionParams, errors),
    subActionParams: subActionParams,
    editAction: editAction,
    editSubAction: editSubAction,
    editOptionalSubAction: editOptionalSubAction,
    errors: errors,
    index: index,
    messageVariables: messageVariables,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }), subAction === _common.OpsgenieSubActions.CloseAlert && /*#__PURE__*/_react.default.createElement(_close_alert.CloseAlert, {
    showSaveError: showCloseAlertSaveError(actionParams, errors),
    subActionParams: subActionParams,
    editSubAction: editSubAction,
    editOptionalSubAction: editOptionalSubAction,
    errors: errors,
    index: index,
    messageVariables: messageVariables,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }));
};
exports.default = OpsgenieParamFields;
OpsgenieParamFields.displayName = 'OpsgenieParamFields';

/**
 * The show*AlertSaveError functions are used to cause a rerender when fields are set to `null` when a user attempts to
 * save the form before providing values for the required fields (message for creating an alert and alias for closing an alert).
 * If we only passed in subActionParams the child components would not rerender because the objects field is only updated
 * and not the entire object.
 */

const showCreateAlertSaveError = (params, errors) => {
  var _errorArray$length, _params$subActionPara;
  const errorArray = errors['subActionParams.message'];
  const errorsLength = (_errorArray$length = errorArray === null || errorArray === void 0 ? void 0 : errorArray.length) !== null && _errorArray$length !== void 0 ? _errorArray$length : 0;
  return isCreateAlertParams(params) && ((_params$subActionPara = params.subActionParams) === null || _params$subActionPara === void 0 ? void 0 : _params$subActionPara.message) === null && errorsLength > 0;
};
const showCloseAlertSaveError = (params, errors) => {
  var _errorArray$length2, _params$subActionPara2;
  const errorArray = errors['subActionParams.alias'];
  const errorsLength = (_errorArray$length2 = errorArray === null || errorArray === void 0 ? void 0 : errorArray.length) !== null && _errorArray$length2 !== void 0 ? _errorArray$length2 : 0;
  return isCloseAlertParams(params) && ((_params$subActionPara2 = params.subActionParams) === null || _params$subActionPara2 === void 0 ? void 0 : _params$subActionPara2.alias) === null && errorsLength > 0;
};
const isCreateAlertParams = params => params.subAction === _common.OpsgenieSubActions.CreateAlert;
const isCloseAlertParams = params => params.subAction === _common.OpsgenieSubActions.CloseAlert;

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;