"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  MESSAGE_NOT_DEFINED: true,
  MESSAGE_NON_WHITESPACE: true,
  LOADING_JSON_EDITOR: true,
  MESSAGE_FIELD_LABEL: true,
  DESCRIPTION_FIELD_LABEL: true,
  USE_JSON_EDITOR_LABEL: true,
  ALERT_FIELDS_LABEL: true,
  JSON_EDITOR_ARIA: true,
  ENTITY_FIELD_LABEL: true,
  TAGS_HELP: true,
  TAGS_FIELD_LABEL: true,
  PRIORITY_LABEL: true,
  PRIORITY_1: true,
  PRIORITY_2: true,
  PRIORITY_3: true,
  PRIORITY_4: true,
  PRIORITY_5: true,
  RULE_TAGS_DESCRIPTION: true,
  REQUIRED_LABEL: true
};
exports.USE_JSON_EDITOR_LABEL = exports.TAGS_HELP = exports.TAGS_FIELD_LABEL = exports.RULE_TAGS_DESCRIPTION = exports.REQUIRED_LABEL = exports.PRIORITY_LABEL = exports.PRIORITY_5 = exports.PRIORITY_4 = exports.PRIORITY_3 = exports.PRIORITY_2 = exports.PRIORITY_1 = exports.MESSAGE_NOT_DEFINED = exports.MESSAGE_NON_WHITESPACE = exports.MESSAGE_FIELD_LABEL = exports.LOADING_JSON_EDITOR = exports.JSON_EDITOR_ARIA = exports.ENTITY_FIELD_LABEL = exports.DESCRIPTION_FIELD_LABEL = exports.ALERT_FIELDS_LABEL = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE_NOT_DEFINED = exports.MESSAGE_NOT_DEFINED = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.messageNotDefined', {
  defaultMessage: '[message]: expected value of type [string] but got [undefined]'
});
const MESSAGE_NON_WHITESPACE = exports.MESSAGE_NON_WHITESPACE = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.messageNotWhitespace', {
  defaultMessage: '[message]: must be populated with a value other than just whitespace'
});
const LOADING_JSON_EDITOR = exports.LOADING_JSON_EDITOR = _i18n.i18n.translate('xpack.stackConnectors.sections.ospgenie.loadingJsonEditor', {
  defaultMessage: 'Loading JSON editor'
});
const MESSAGE_FIELD_LABEL = exports.MESSAGE_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.messageLabel', {
  defaultMessage: 'Message'
});
const DESCRIPTION_FIELD_LABEL = exports.DESCRIPTION_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.descriptionLabel', {
  defaultMessage: 'Description'
});
const USE_JSON_EDITOR_LABEL = exports.USE_JSON_EDITOR_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.useJsonEditorLabel', {
  defaultMessage: 'Use JSON editor'
});
const ALERT_FIELDS_LABEL = exports.ALERT_FIELDS_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.alertFieldsLabel', {
  defaultMessage: 'Alert fields'
});
const JSON_EDITOR_ARIA = exports.JSON_EDITOR_ARIA = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.jsonEditorAriaLabel', {
  defaultMessage: 'JSON editor'
});
const ENTITY_FIELD_LABEL = exports.ENTITY_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.entityLabel', {
  defaultMessage: 'Entity'
});
const TAGS_HELP = exports.TAGS_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.tagsHelp', {
  defaultMessage: 'Press enter after each tag to begin a new one.'
});
const TAGS_FIELD_LABEL = exports.TAGS_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.tagsLabel', {
  defaultMessage: 'Opsgenie tags'
});
const PRIORITY_LABEL = exports.PRIORITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priorityLabel', {
  defaultMessage: 'Priority'
});
const PRIORITY_1 = exports.PRIORITY_1 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority1', {
  defaultMessage: 'P1-Critical'
});
const PRIORITY_2 = exports.PRIORITY_2 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority2', {
  defaultMessage: 'P2-High'
});
const PRIORITY_3 = exports.PRIORITY_3 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority3', {
  defaultMessage: 'P3-Moderate'
});
const PRIORITY_4 = exports.PRIORITY_4 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority4', {
  defaultMessage: 'P4-Low'
});
const PRIORITY_5 = exports.PRIORITY_5 = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.priority5', {
  defaultMessage: 'P5-Information'
});
const RULE_TAGS_DESCRIPTION = exports.RULE_TAGS_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.ruleTagsDescription', {
  defaultMessage: 'The tags of the rule.'
});
const REQUIRED_LABEL = exports.REQUIRED_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.requiredLabel', {
  defaultMessage: 'Required'
});