"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUMMARY_REQUIRED = exports.SEARCH_ISSUES_PLACEHOLDER = exports.SEARCH_ISSUES_LOADING = exports.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = exports.OTHER_FIELDS_LENGTH_ERROR = exports.LABELS_WHITE_SPACES = exports.JIRA_PROJECT_KEY_LABEL = exports.JIRA_EMAIL_LABEL = exports.JIRA_API_TOKEN_LABEL = exports.ISSUE_TYPES_API_ERROR = exports.ISSUES_API_ERROR = exports.INVALID_JSON_FORMAT = exports.GET_ISSUE_API_ERROR = exports.FIELDS_API_ERROR = exports.API_URL_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
const JIRA_PROJECT_KEY_LABEL = exports.JIRA_PROJECT_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.projectKey', {
  defaultMessage: 'Project key'
});
const JIRA_EMAIL_LABEL = exports.JIRA_EMAIL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.emailTextFieldLabel', {
  defaultMessage: 'Email address'
});
const JIRA_API_TOKEN_LABEL = exports.JIRA_API_TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.apiTokenTextFieldLabel', {
  defaultMessage: 'API token'
});
const SUMMARY_REQUIRED = exports.SUMMARY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.jira.requiredSummaryTextField', {
  defaultMessage: 'Summary is required.'
});
const ISSUE_TYPES_API_ERROR = exports.ISSUE_TYPES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetIssueTypesMessage', {
  defaultMessage: 'Unable to get issue types'
});
const FIELDS_API_ERROR = exports.FIELDS_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetFieldsMessage', {
  defaultMessage: 'Unable to get fields'
});
const ISSUES_API_ERROR = exports.ISSUES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetIssuesMessage', {
  defaultMessage: 'Unable to get issues'
});
const GET_ISSUE_API_ERROR = id => _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetIssueMessage', {
  defaultMessage: 'Unable to get issue with id {id}',
  values: {
    id
  }
});
exports.GET_ISSUE_API_ERROR = GET_ISSUE_API_ERROR;
const SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = exports.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.searchIssuesComboBoxAriaLabel', {
  defaultMessage: 'Type to search'
});
const SEARCH_ISSUES_PLACEHOLDER = exports.SEARCH_ISSUES_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.components.jira.searchIssuesComboBoxPlaceholder', {
  defaultMessage: 'Type to search'
});
const SEARCH_ISSUES_LOADING = exports.SEARCH_ISSUES_LOADING = _i18n.i18n.translate('xpack.stackConnectors.components.jira.searchIssuesLoading', {
  defaultMessage: 'Loading...'
});
const LABELS_WHITE_SPACES = exports.LABELS_WHITE_SPACES = _i18n.i18n.translate('xpack.stackConnectors.components.jira.labelsSpacesErrorMessage', {
  defaultMessage: 'Labels cannot contain spaces.'
});
const INVALID_JSON_FORMAT = exports.INVALID_JSON_FORMAT = _i18n.i18n.translate('xpack.stackConnectors.components.jira.otherFieldsFormatErrorMessage', {
  defaultMessage: 'Additional fields field must be a valid JSON object.'
});
const OTHER_FIELDS_LENGTH_ERROR = length => _i18n.i18n.translate('xpack.stackConnectors.jira.schema.additionalFieldsLengthError', {
  values: {
    length
  },
  defaultMessage: 'A maximum of {length} additional fields can be defined at a time.'
});
exports.OTHER_FIELDS_LENGTH_ERROR = OTHER_FIELDS_LENGTH_ERROR;