"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.UsageCostMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/triggers-actions-ui-plugin/public/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/inference/usage_cost_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UsageCostMessage = () => {
  const {
    docLinks
  } = (0, _common.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.inference.elasticLLM.descriptionText",
    defaultMessage: "Learn more about {elasticLLM} and its {usageCost}.",
    values: {
      elasticLLM: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "elasticManagedLlmLink",
        href: docLinks.links.observability.elasticManagedLlm,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 22,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.inference.elasticLLM.link",
        defaultMessage: "Elastic Managed LLM connector",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 15
        }
      })),
      usageCost: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.observability.elasticManagedLlmUsageCost,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.inference.elasticLLM.usageCost.link",
        defaultMessage: "usage cost",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 7
    }
  }));
};
// eslint-disable-next-line import/no-default-export
exports.default = exports.UsageCostMessage = UsageCostMessage;