"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERNAME_REQUIRED = exports.USERNAME_LABEL = exports.TO_CC_REQUIRED = exports.TENANT_ID_REQUIRED = exports.TENANT_ID_LABEL = exports.SUBJECT_REQUIRED = exports.SERVICE_REQUIRED = exports.SERVICE_LABEL = exports.SENDER_REQUIRED = exports.SECURE_LABEL = exports.PORT_REQUIRED = exports.PORT_LABEL = exports.PORT_INVALID = exports.PASSWORD_REQUIRED = exports.PASSWORD_LABEL = exports.MESSAGE_REQUIRED = exports.HOST_REQUIRED = exports.HOST_LABEL = exports.HAS_AUTH_LABEL = exports.FROM_LABEL = exports.CLIENT_SECRET_REQUIRED = exports.CLIENT_SECRET_LABEL = exports.CLIENT_ID_REQUIRED = exports.CLIENT_ID_LABEL = void 0;
exports.getInvalidEmailAddress = getInvalidEmailAddress;
exports.getNotAllowedEmailAddress = getNotAllowedEmailAddress;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USERNAME_LABEL = exports.USERNAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.userTextFieldLabel', {
  defaultMessage: 'Username'
});
const PASSWORD_LABEL = exports.PASSWORD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.passwordFieldLabel', {
  defaultMessage: 'Password'
});
const FROM_LABEL = exports.FROM_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.fromTextFieldLabel', {
  defaultMessage: 'Sender'
});
const SERVICE_LABEL = exports.SERVICE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.serviceTextFieldLabel', {
  defaultMessage: 'Service'
});
const TENANT_ID_LABEL = exports.TENANT_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.tenantIdFieldLabel', {
  defaultMessage: 'Tenant ID'
});
const CLIENT_ID_LABEL = exports.CLIENT_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.clientIdFieldLabel', {
  defaultMessage: 'Client ID'
});
const CLIENT_SECRET_LABEL = exports.CLIENT_SECRET_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.clientSecretTextFieldLabel', {
  defaultMessage: 'Client Secret'
});
const HOST_LABEL = exports.HOST_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.hostTextFieldLabel', {
  defaultMessage: 'Host'
});
const PORT_LABEL = exports.PORT_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.portTextFieldLabel', {
  defaultMessage: 'Port'
});
const SECURE_LABEL = exports.SECURE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.secureSwitchLabel', {
  defaultMessage: 'Secure'
});
const HAS_AUTH_LABEL = exports.HAS_AUTH_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.email.hasAuthSwitchLabel', {
  defaultMessage: 'Require authentication for this server'
});
const SENDER_REQUIRED = exports.SENDER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredFromText', {
  defaultMessage: 'Sender is required.'
});
const CLIENT_ID_REQUIRED = exports.CLIENT_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredClientIdText', {
  defaultMessage: 'Client ID is required.'
});
const TENANT_ID_REQUIRED = exports.TENANT_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredTenantIdText', {
  defaultMessage: 'Tenant ID is required.'
});
const PORT_REQUIRED = exports.PORT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredPortText', {
  defaultMessage: 'Port is required.'
});
const PORT_INVALID = exports.PORT_INVALID = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.invalidPortText', {
  defaultMessage: 'Port is invalid.'
});
const SERVICE_REQUIRED = exports.SERVICE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredServiceText', {
  defaultMessage: 'Service is required.'
});
const HOST_REQUIRED = exports.HOST_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredHostText', {
  defaultMessage: 'Host is required.'
});
const USERNAME_REQUIRED = exports.USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredAuthUserNameText', {
  defaultMessage: 'Username is required.'
});
const TO_CC_REQUIRED = exports.TO_CC_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredEntryText', {
  defaultMessage: 'No To, Cc, or Bcc entry.  At least one entry is required.'
});
const MESSAGE_REQUIRED = exports.MESSAGE_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredMessageText', {
  defaultMessage: 'Message is required.'
});
const SUBJECT_REQUIRED = exports.SUBJECT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredSubjectText', {
  defaultMessage: 'Subject is required.'
});
const PASSWORD_REQUIRED = exports.PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.error.requiredPasswordText', {
  defaultMessage: 'Password is required.'
});
const CLIENT_SECRET_REQUIRED = exports.CLIENT_SECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.email.requiredClientSecretText', {
  defaultMessage: 'Client Secret is required.'
});
function getInvalidEmailAddress(email) {
  return _i18n.i18n.translate('xpack.stackConnectors.components.email.error.invalidEmail', {
    defaultMessage: 'Email address {email} is not valid.',
    values: {
      email
    }
  });
}
function getNotAllowedEmailAddress(email) {
  return _i18n.i18n.translate('xpack.stackConnectors.components.email.error.notAllowed', {
    defaultMessage: 'Email address {email} is not allowed.',
    values: {
      email
    }
  });
}