"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/crowdstrike/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/crowdstrike/crowdstrike_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const actionTypeOptions = [{
  value: _constants.SUB_ACTION.GET_AGENT_DETAILS,
  inputDisplay: i18n.GET_AGENT_DETAILS_ACTION_LABEL
}];
const CrowdstrikeParamsFields = ({
  actionParams,
  editAction,
  index,
  errors
}) => {
  const [subActionValue] = (0, _react.useState)(_constants.SUB_ACTION.GET_AGENT_DETAILS);
  const {
    ids
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      ids: []
    };
  }, [actionParams.subActionParams]);
  const labelOptions = (0, _react.useMemo)(() => ids ? ids.map(label => ({
    label
  })) : [], [ids]);
  const editSubActionParams = (0, _react.useCallback)(value => {
    return editAction('subActionParams', {
      ids: value
    }, index);
  }, [editAction, index]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', _constants.SUB_ACTION.GET_AGENT_DETAILS, index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        ids: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.ACTION_TYPE_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    options: actionTypeOptions,
    valueOfSelected: subActionValue,
    readOnly: true,
    "data-test-subj": "actionTypeSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.AGENT_IDS_LABEL,
    error: errors['subActionParams.ids'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    fullWidth: true,
    selectedOptions: labelOptions,
    onCreateOption: searchValue => {
      const newOptions = [...labelOptions, {
        label: searchValue
      }];
      editSubActionParams(newOptions.map(newOption => newOption.label));
    },
    onChange: selectedOptions => {
      editSubActionParams(selectedOptions.map(selectedOption => selectedOption.label));
    },
    onBlur: () => {
      if (!ids) {
        editSubActionParams([]);
      }
    },
    isClearable: true,
    "data-test-subj": "agentIdSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = CrowdstrikeParamsFields;
module.exports = exports.default;