"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageSpacesButton = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/nav_control/components/manage_spaces_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ManageSpacesButton = ({
  isDisabled,
  size,
  fullWidth,
  onClick,
  capabilities,
  navigateToApp
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navigateToManageSpaces = () => {
    if (onClick) {
      onClick();
    }
    navigateToApp('management', {
      path: 'kibana/spaces'
    });
  };
  if (!capabilities.spaces.manage) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    size: size || 's',
    isDisabled: isDisabled,
    onClick: navigateToManageSpaces,
    "data-test-subj": "manageSpaces",
    css: fullWidth ? {
      width: `100%`
    } : (0, _react.css)`
              margin: ${euiTheme.size.m};
              width: calc(100% - ${euiTheme.size.m} * 2);
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.manageSpacesButton.manageSpacesButtonLabel",
    defaultMessage: "Manage spaces",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
};
exports.ManageSpacesButton = ManageSpacesButton;