"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSpaceRolesReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSpaceRolesReducer = (state, action) => {
  const clonedState = structuredClone(state);
  switch (action.type) {
    case 'update_roles':
      {
        if (action.payload) {
          action.payload.forEach(role => {
            clonedState.roles.set(role.name, role);
          });
        }
        return clonedState;
      }
    case 'remove_roles':
      {
        action.payload.forEach(role => {
          clonedState.roles.delete(role.name);
        });
        return clonedState;
      }
    case 'fetch_roles_error':
      {
        clonedState.fetchRolesError = action.payload;
        return clonedState;
      }
    default:
      {
        return clonedState;
      }
  }
};
exports.createSpaceRolesReducer = createSpaceRolesReducer;