"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSpacesButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _confirm_delete_modal = require("./confirm_delete_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/components/delete_spaces_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DeleteSpacesButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showConfirmDeleteModal: false,
      showConfirmRedirectModal: false
    });
    (0, _defineProperty2.default)(this, "onDeleteClick", () => {
      this.setState({
        showConfirmDeleteModal: true
      });
    });
    (0, _defineProperty2.default)(this, "getConfirmDeleteModal", () => {
      if (!this.state.showConfirmDeleteModal) {
        return null;
      }
      const {
        spacesManager
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
        space: this.props.space,
        spacesManager: spacesManager,
        onCancel: () => {
          this.setState({
            showConfirmDeleteModal: false
          });
        },
        onSuccess: () => {
          var _this$props$onDelete, _this$props;
          this.setState({
            showConfirmDeleteModal: false
          });
          (_this$props$onDelete = (_this$props = this.props).onDelete) === null || _this$props$onDelete === void 0 ? void 0 : _this$props$onDelete.call(_this$props);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 7
        }
      });
    });
  }
  render() {
    const buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.deleteSpacesButton.deleteSpaceButtonLabel",
      defaultMessage: "Delete space",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    });
    let ButtonComponent = _eui.EuiButton;
    let extraProps;
    if (this.props.style === 'icon') {
      ButtonComponent = _eui.EuiButtonIcon;
      extraProps = {
        iconType: 'trash'
      };
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(ButtonComponent, (0, _extends2.default)({
      color: 'danger',
      onClick: this.onDeleteClick,
      "aria-label": _i18n.i18n.translate('xpack.spaces.management.deleteSpacesButton.deleteSpaceAriaLabel', {
        defaultMessage: 'Delete this space'
      })
    }, extraProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }), buttonText), this.getConfirmDeleteModal());
  }
}
exports.DeleteSpacesButton = DeleteSpacesButton;