"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmAlterActiveSpaceModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/components/confirm_alter_active_space_modal/confirm_alter_active_space_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmAlterActiveSpaceModalUI = props => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onConfirm: props.onConfirm,
    onCancel: props.onCancel,
    "aria-labelledby": modalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.confirmAlterActiveSpaceModal.title",
      defaultMessage: "Confirm update space",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    defaultFocusedButton: 'confirm',
    cancelButtonText: props.intl.formatMessage({
      id: 'xpack.spaces.management.confirmAlterActiveSpaceModal.cancelButton',
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: props.intl.formatMessage({
      id: 'xpack.spaces.management.confirmAlterActiveSpaceModal.updateSpaceButton',
      defaultMessage: 'Update space'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.confirmAlterActiveSpaceModal.reloadWarningMessage",
    defaultMessage: "You have updated the visible features in this space. Your page will reload after saving.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
};
const ConfirmAlterActiveSpaceModal = exports.ConfirmAlterActiveSpaceModal = (0, _i18nReact.injectI18n)(ConfirmAlterActiveSpaceModalUI);