"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceResultProcessing = exports.SpaceResult = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _copy_status_summary_indicator = require("./copy_status_summary_indicator");
var _space_result_details = require("./space_result_details");
var _space_avatar = require("../../space_avatar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/space_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react2.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const getInitialDestinationMap = objects => objects.reduce((acc, {
  type,
  id,
  conflict
}) => {
  if ((conflict === null || conflict === void 0 ? void 0 : conflict.error.type) === 'ambiguous_conflict') {
    acc.set(`${type}:${id}`, conflict.error.destinations[0].id);
  }
  return acc;
}, new Map());
const SpaceResultProcessing = props => {
  const {
    space
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: `copyToSpace-${space.id}`,
    "data-test-subj": `cts-space-result-${space.id}`,
    css: (0, _react.css)`
        padding-bottom: ${euiTheme.size.s};
        border-bottom: ${euiTheme.border.thin};
      `,
    buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
      fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 33
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(LazySpaceAvatar, {
      space: space,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }, space.name))),
    extraAction: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 20
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
};
exports.SpaceResultProcessing = SpaceResultProcessing;
const SpaceResult = props => {
  const {
    space,
    summarizedCopyResult,
    retries,
    onRetriesChange,
    conflictResolutionInProgress
  } = props;
  const {
    objects
  } = summarizedCopyResult;
  const spaceHasPendingOverwrites = retries.some(r => r.overwrite);
  const [destinationMap, setDestinationMap] = (0, _react2.useState)(getInitialDestinationMap(objects));
  const onDestinationMapChange = value => {
    setDestinationMap(value || getInitialDestinationMap(objects));
  };
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: `copyToSpace-${space.id}`,
    "data-test-subj": `cts-space-result-${space.id}`,
    css: (0, _react.css)`
        padding-bottom: ${euiTheme.size.s};
        border-bottom: ${euiTheme.border.thin};
      `,
    buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
      fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 33
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(LazySpaceAvatar, {
      space: space,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }, space.name))),
    extraAction: /*#__PURE__*/_react2.default.createElement(_copy_status_summary_indicator.CopyStatusSummaryIndicator, {
      space: space,
      retries: retries,
      onRetriesChange: onRetriesChange,
      onDestinationMapChange: onDestinationMapChange,
      summarizedCopyResult: summarizedCopyResult,
      conflictResolutionInProgress: conflictResolutionInProgress && spaceHasPendingOverwrites,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_space_result_details.SpaceCopyResultDetails, {
    summarizedCopyResult: summarizedCopyResult,
    space: space,
    retries: retries,
    onRetriesChange: onRetriesChange,
    destinationMap: destinationMap,
    onDestinationMapChange: onDestinationMapChange,
    conflictResolutionInProgress: conflictResolutionInProgress && spaceHasPendingOverwrites,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }));
};
exports.SpaceResult = SpaceResult;