"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotRestoreLocatorDefinition = exports.SNAPSHOT_RESTORE_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _navigation = require("./application/services/navigation");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SNAPSHOT_RESTORE_LOCATOR_ID = exports.SNAPSHOT_RESTORE_LOCATOR_ID = 'SNAPSHOT_RESTORE_LOCATOR';
class SnapshotRestoreLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", SNAPSHOT_RESTORE_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const location = await this.deps.managementAppLocator.getLocation({
        sectionId: 'data',
        appId: _constants.PLUGIN.id
      });
      switch (params.page) {
        case 'snapshots':
          {
            return {
              ...location,
              path: location.path + (0, _navigation.linkToSnapshots)()
            };
          }
      }
    });
    this.deps = deps;
  }
}
exports.SnapshotRestoreLocatorDefinition = SnapshotRestoreLocatorDefinition;