"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.linkToAddPolicy = linkToAddPolicy;
exports.linkToAddRepository = linkToAddRepository;
exports.linkToEditPolicy = linkToEditPolicy;
exports.linkToEditRepository = linkToEditRepository;
exports.linkToHome = linkToHome;
exports.linkToPolicies = linkToPolicies;
exports.linkToPolicy = linkToPolicy;
exports.linkToRepositories = linkToRepositories;
exports.linkToRepository = linkToRepository;
exports.linkToRestoreSnapshot = linkToRestoreSnapshot;
exports.linkToRestoreStatus = linkToRestoreStatus;
exports.linkToSnapshot = linkToSnapshot;
exports.linkToSnapshots = linkToSnapshots;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function linkToHome() {
  return `/`;
}
function linkToRepositories() {
  return `/repositories`;
}
function linkToRepository(repositoryName) {
  return encodeURI(`/repositories/${encodeURIComponent(repositoryName)}`);
}
function linkToEditRepository(repositoryName) {
  return encodeURI(`/edit_repository/${encodeURIComponent(repositoryName)}`);
}
function linkToAddRepository(redirect) {
  return encodeURI(`/add_repository${redirect ? `?redirect=${encodeURIComponent(redirect)}` : ''}`);
}
function linkToSnapshots(repositoryName, policyName) {
  if (repositoryName) {
    return encodeURI(`/snapshots?repository=${encodeURIComponent(repositoryName)}`);
  }
  if (policyName) {
    return encodeURI(`/snapshots?policy=${encodeURIComponent(policyName)}`);
  }
  return `/snapshots`;
}
function linkToSnapshot(repositoryName, snapshotName) {
  return encodeURI(`/snapshots/${encodeURIComponent(repositoryName)}/${encodeURIComponent(snapshotName)}`);
}
function linkToRestoreSnapshot(repositoryName, snapshotName) {
  return encodeURI(`/restore/${encodeURIComponent(repositoryName)}/${encodeURIComponent(snapshotName)}`);
}
function linkToPolicies() {
  return `/policies`;
}
function linkToPolicy(policyName) {
  return encodeURI(`/policies/${encodeURIComponent(policyName)}`);
}
function linkToEditPolicy(policyName) {
  return encodeURI(`/edit_policy/${encodeURIComponent(policyName)}`);
}
function linkToAddPolicy() {
  return `/add_policy`;
}
function linkToRestoreStatus() {
  return `/restore_status`;
}