"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadRestores = exports.setUiMetricServiceRestore = exports.executeRestore = void 0;
var _constants = require("../../../../common/constants");
var _constants2 = require("../../constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Temporary hack to provide the uiMetricService instance to this file.
// TODO: Refactor and export an ApiService instance through the app dependencies context
let uiMetricService;
const setUiMetricServiceRestore = _uiMetricService => {
  uiMetricService = _uiMetricService;
};
// End hack
exports.setUiMetricServiceRestore = setUiMetricServiceRestore;
const executeRestore = async (repository, snapshot, restoreSettings) => {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}restore/${encodeURIComponent(repository)}/${encodeURIComponent(snapshot)}`,
    method: 'post',
    body: restoreSettings
  });
  uiMetricService.trackUiMetric(_constants2.UIM_RESTORE_CREATE);
  return result;
};
exports.executeRestore = executeRestore;
const useLoadRestores = pollIntervalMs => {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}restores`,
    method: 'get',
    initialData: [],
    pollIntervalMs
  });
};
exports.useLoadRestores = useLoadRestores;