"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshot = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../constants");
var _components = require("../../components");
var _app_context = require("../../app_context");
var _navigation = require("../../services/navigation");
var _http = require("../../services/http");
var _lib = require("../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/restore_snapshot/restore_snapshot.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RestoreSnapshot = ({
  history
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    repositoryName,
    snapshotId
  } = (0, _lib.useDecodedParams)();

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs('restoreSnapshot');
    _navigation.docTitleService.setTitle('restoreSnapshot');
  }, []);

  // Snapshot details state with default empty snapshot
  const [snapshotDetails, setSnapshotDetails] = (0, _react.useState)({});

  // Load snapshot
  const {
    error: snapshotError,
    isLoading: loadingSnapshot,
    data: snapshotData
  } = (0, _http.useLoadSnapshot)(repositoryName, snapshotId);

  // Update repository state when data is loaded
  (0, _react.useEffect)(() => {
    if (snapshotData) {
      setSnapshotDetails(snapshotData);
    }
  }, [snapshotData]);

  // Saving repository states
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);

  // Execute restore
  const onSave = async restoreSettings => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _http.executeRestore)(repositoryName, snapshotId, restoreSettings);
    if (error) {
      setIsSaving(false);
      setSaveError(error);
    } else {
      // Wait a few seconds before redirecting so that restore information has time to
      // populate into master node
      setTimeout(() => {
        setIsSaving(false);
        history.push(`${_constants.BASE_PATH}/restore_status`);
      }, 5 * 1000);
    }
  };
  const renderLoading = () => {
    return /*#__PURE__*/_react.default.createElement(_components.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreSnapshot.loadingSnapshotDescription",
      defaultMessage: "Loading snapshot details\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }));
  };
  const renderError = () => {
    const notFound = snapshotError.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.restoreSnapshot.snapshotNotFoundErrorMessage', {
          defaultMessage: `The snapshot ''{snapshot}'' does not exist in repository ''{repository}''.`,
          values: {
            snapshot: snapshotId,
            repository: repositoryName
          }
        })
      }
    } : snapshotError;
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreSnapshot.loadingSnapshotErrorTitle",
        defaultMessage: "Error loading snapshot details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 11
        }
      }),
      error: errorObject,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    });
  };
  const renderSaveError = () => {
    return saveError ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreSnapshot.executeRestoreErrorTitle",
        defaultMessage: "Unable to restore snapshot",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      }),
      error: saveError,
      "data-test-subj": "restoreSnapshotError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }) : null;
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  if (loadingSnapshot) {
    return renderLoading();
  }
  if (snapshotError) {
    return renderError();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreSnapshotTitle",
      defaultMessage: "Restore ''{snapshot}''",
      values: {
        snapshot: snapshotId
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.RestoreSnapshotForm, {
    snapshotDetails: snapshotDetails,
    isSaving: isSaving,
    saveError: renderSaveError(),
    clearSaveError: clearSaveError,
    onSave: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }));
};
exports.RestoreSnapshot = RestoreSnapshot;