"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../lib");
var _constants = require("../../../../common/constants");
var _components = require("../../components");
var _constants2 = require("../../constants");
var _app_context = require("../../app_context");
var _navigation = require("../../services/navigation");
var _http = require("../../services/http");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/policy_edit/policy_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyEdit = ({
  history,
  location: {
    pathname
  }
}) => {
  const {
    name
  } = (0, _lib.useDecodedParams)();
  const {
    i18n
  } = (0, _app_context.useServices)();

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs('policyEdit');
    _navigation.docTitleService.setTitle('policyEdit');
  }, []);

  // Policy state with default empty policy
  const [policy, setPolicy] = (0, _react.useState)({
    name: '',
    snapshotName: '',
    schedule: '',
    repository: '',
    config: {},
    retention: {
      expireAfterValue: '',
      expireAfterUnit: _constants.TIME_UNITS.DAY,
      maxCount: '',
      minCount: ''
    },
    isManagedPolicy: false
  });
  const {
    error: errorLoadingIndices,
    isLoading: isLoadingIndices,
    data: indicesData
  } = (0, _http.useLoadIndices)();

  // Load policy
  const {
    error: errorLoadingPolicy,
    isLoading: isLoadingPolicy,
    data: policyData
  } = (0, _http.useLoadPolicy)(name);

  // Update policy state when data is loaded
  (0, _react.useEffect)(() => {
    if (policyData !== null && policyData !== void 0 && policyData.policy) {
      const {
        policy: policyToEdit
      } = policyData;

      // The policy response includes data not pertinent to the form
      // that we need to remove, e.g., lastSuccess, lastFailure, stats
      const policyFormData = {
        name: policyToEdit.name,
        snapshotName: policyToEdit.snapshotName,
        schedule: policyToEdit.schedule,
        repository: policyToEdit.repository,
        config: policyToEdit.config,
        retention: policyToEdit.retention,
        isManagedPolicy: policyToEdit.isManagedPolicy
      };
      setPolicy(policyFormData);
    }
  }, [policyData]);

  // Saving policy states
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);

  // Save policy
  const onSave = async editedPolicy => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _http.editPolicy)(editedPolicy);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
    } else {
      history.push(encodeURI(`${_constants2.BASE_PATH}/policies/${encodeURIComponent(name)}`));
    }
  };
  const onCancel = () => {
    history.push(encodeURI(`${_constants2.BASE_PATH}/policies/${encodeURIComponent(name)}`));
  };
  const renderSaveError = () => {
    return saveError ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.editPolicy.savingPolicyErrorTitle",
        defaultMessage: "Cannot save policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 11
        }
      }),
      error: saveError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }) : null;
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  const renderLoading = () => {
    return isLoadingPolicy ? /*#__PURE__*/_react.default.createElement(_components.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editPolicy.loadingPolicyDescription",
      defaultMessage: "Loading policy details\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    })) : /*#__PURE__*/_react.default.createElement(_components.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editPolicy.loadingIndicesDescription",
      defaultMessage: "Loading available indices\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }));
  };
  const renderError = () => {
    if (errorLoadingPolicy) {
      const notFound = errorLoadingPolicy.status === 404;
      const errorObject = notFound ? {
        data: {
          error: i18n.translate('xpack.snapshotRestore.editPolicy.policyNotFoundErrorMessage', {
            defaultMessage: `The policy ''{name}'' does not exist.`,
            values: {
              name
            }
          })
        }
      } : errorLoadingPolicy;
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.editPolicy.loadingPolicyErrorTitle",
          defaultMessage: "Error loading policy details",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 13
          }
        }),
        error: errorObject,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.editPolicy.LoadingIndicesErrorMessage",
        defaultMessage: "Error loading available indices",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 11
        }
      }),
      error: errorLoadingIndices,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 7
      }
    });
  };
  if (isLoadingPolicy || isLoadingIndices) {
    return renderLoading();
  }
  if (errorLoadingPolicy || errorLoadingIndices) {
    return renderError();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editPolicyTitle",
      defaultMessage: "Edit policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }), policy.isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.editPolicy.managedPolicyWarningTitle",
      defaultMessage: "This is a managed policy. Changing this policy might affect other systems that use it. Proceed with caution.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_components.PolicyForm, {
    policy: policy,
    dataStreams: indicesData.dataStreams,
    indices: indicesData.indices,
    currentUrl: pathname,
    isEditing: true,
    isSaving: isSaving,
    saveError: renderSaveError(),
    clearSaveError: clearSaveError,
    onSave: onSave,
    onCancel: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }));
};
exports.PolicyEdit = PolicyEdit;