"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _queryString = require("query-string");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../constants");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _app_context = require("../../../app_context");
var _lib = require("../../../lib");
var _snapshot_details = require("./snapshot_details");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/snapshot_list/snapshot_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapshotList = ({
  location: {
    search
  },
  history
}) => {
  const {
    repositoryName,
    snapshotId
  } = (0, _lib.useDecodedParams)();
  const [listParams, setListParams] = (0, _react.useState)(_lib.DEFAULT_SNAPSHOT_LIST_PARAMS);
  const {
    error,
    isInitialRequest: isSnapshotsInitialRequest,
    isLoading: isSnapshotsLoading,
    data: {
      snapshots = [],
      policies = [],
      errors = {},
      total: totalSnapshotsCount
    },
    resendRequest: reload
  } = (0, _http.useLoadSnapshots)(listParams);
  // To make the repository filter work in the search bar (even when snapshots request fails), we need to load repositories separately.
  // For more context see https://github.com/elastic/kibana/issues/225935
  const {
    isInitialRequest: isRepositoriesInitialRequest,
    isLoading: isRepositoriesLoading,
    data: {
      repositories = []
    }
  } = (0, _http.useLoadRepositories)();
  const isInitialRequest = isSnapshotsInitialRequest && isRepositoriesInitialRequest;
  const isLoading = isSnapshotsLoading || isRepositoriesLoading;
  const repositoriesNames = repositories.map(repository => repository === null || repository === void 0 ? void 0 : repository.name);
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    core
  } = (0, _app_context.useAppContext)();
  const closeSnapshotDetails = () => {
    history.push(`${_constants.BASE_PATH}/snapshots`);
  };
  const onSnapshotDeleted = snapshotsDeleted => {
    if (repositoryName && snapshotId && snapshotsDeleted.find(({
      snapshot,
      repository
    }) => snapshot === snapshotId && repository === repositoryName)) {
      closeSnapshotDetails();
    }
    if (snapshotsDeleted.length) {
      reload();
    }
  };
  (0, _shared_imports.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'snapshotRestoreSnapshotTab'
  });

  // Allow deeplinking to list pre-filtered by repository name or by policy name
  (0, _react.useEffect)(() => {
    if (search) {
      const parsedParams = (0, _queryString.parse)(search.replace(/^\?/, ''), {
        sort: false
      });
      const {
        repository,
        policy
      } = parsedParams;
      if (policy) {
        setListParams(prev => ({
          ...prev,
          searchField: 'policyName',
          searchValue: String(policy),
          searchMatch: 'must',
          searchOperator: 'exact'
        }));
        history.replace(`${_constants.BASE_PATH}/snapshots`);
      } else if (repository) {
        setListParams(prev => ({
          ...prev,
          searchField: 'repository',
          searchValue: String(repository),
          searchMatch: 'must',
          searchOperator: 'exact'
        }));
        history.replace(`${_constants.BASE_PATH}/snapshots`);
      }
    }
  }, [listParams, history, search]);

  // Track component loaded
  (0, _react.useEffect)(() => {
    uiMetricService.trackUiMetric(_constants.UIM_SNAPSHOT_LIST_LOAD);
  }, [uiMetricService]);
  let content;

  // display "loading" section only on initial load, after that the table will have a loading indicator
  if (isInitialRequest && isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "snapshotListEmpty",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.loadingSnapshotsDescription",
      defaultMessage: "Loading snapshots\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    })));
  } else if (!error && repositoriesNames.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_components.RepositoryEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 15
      }
    });
  } else if (!error && totalSnapshotsCount === 0 && !listParams.searchField && !isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_components.SnapshotEmptyPrompt, {
      policiesCount: policies.length,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    });
  } else {
    let snapshotsLoadingError = null;
    if (error) {
      var _error$attributes, _error$attributes$err;
      if ((error === null || error === void 0 ? void 0 : (_error$attributes = error.attributes) === null || _error$attributes === void 0 ? void 0 : (_error$attributes$err = _error$attributes.error) === null || _error$attributes$err === void 0 ? void 0 : _error$attributes$err.type) === _constants.SNAPSHOT_REPOSITORY_EXCEPTION_ERROR) {
        snapshotsLoadingError = /*#__PURE__*/_react.default.createElement(_components.RepositoryError, {
          errorMessage: error === null || error === void 0 ? void 0 : error.message,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 33
          }
        });
      } else {
        snapshotsLoadingError = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.snapshotRestore.snapshotList.loadingSnapshotsErrorMessage",
            defaultMessage: "Error loading snapshots",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 160,
              columnNumber: 15
            }
          }),
          "data-test-subj": "snapshotsLoadingError",
          error: error,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 11
          }
        });
      }
    }
    const repositoryErrorsWarning = Object.keys(errors).length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryWarningTitle",
        defaultMessage: "Some repositories contain errors",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      }),
      color: "warning",
      iconType: "warning",
      "data-test-subj": "repositoryErrorsWarning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryWarningDescription",
      defaultMessage: "Snapshots might load slowly. Go to {repositoryLink} to fix the errors.",
      values: {
        repositoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRepositories)()), {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 190,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryWarningLinkText",
          defaultMessage: "Repositories",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 191,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    })) : null;
    content = /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "snapshotList",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 7
      }
    }, repositoryErrorsWarning, /*#__PURE__*/_react.default.createElement(_components.SnapshotTable, {
      snapshots: snapshots,
      repositories: repositoriesNames,
      reload: reload,
      onSnapshotDeleted: onSnapshotDeleted,
      listParams: listParams,
      setListParams: setListParams,
      totalItemCount: totalSnapshotsCount,
      isLoading: isLoading,
      error: snapshotsLoadingError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, repositoryName && snapshotId ? /*#__PURE__*/_react.default.createElement(_snapshot_details.SnapshotDetails, {
    repositoryName: repositoryName,
    snapshotId: snapshotId,
    onClose: closeSnapshotDetails,
    onSnapshotDeleted: onSnapshotDeleted,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  }) : null, content);
};
exports.SnapshotList = SnapshotList;