"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsAndIndicesListHelpText = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/policy_form/steps/step_settings/fields/indices_and_data_streams_field/data_streams_and_indices_list_help_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataStreamsAndIndicesListHelpText = ({
  onSelectionChange,
  selectedIndicesAndDataStreams,
  indices,
  dataStreams
}) => {
  if (selectedIndicesAndDataStreams.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.noDataStreamsOrIndicesHelpText",
      defaultMessage: "Nothing will be backed up. {selectAllLink}",
      values: {
        selectAllLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            onSelectionChange('all');
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 33,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.stepSettings.selectAllIndicesLink",
          defaultMessage: "Select all",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 15
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    });
  }
  const indicesCount = selectedIndicesAndDataStreams.reduce((acc, v) => indices.includes(v) ? acc + 1 : acc, 0);
  const dataStreamsCount = selectedIndicesAndDataStreams.reduce((acc, v) => dataStreams.includes(v) ? acc + 1 : acc, 0);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepSettings.selectDataStreamsIndicesHelpText",
    defaultMessage: "{indicesCount} {indicesCount, plural, one {index} other {indices}} and {dataStreamsCount} {dataStreamsCount, plural, one {data stream} other {data streams}} will be backed up. {deselectAllLink}",
    values: {
      dataStreamsCount,
      indicesCount,
      deselectAllLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "deselectIndicesLink",
        onClick: () => {
          onSelectionChange('none');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepSettings.deselectAllIndicesLink",
        defaultMessage: "Deselect all",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 13
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
};
exports.DataStreamsAndIndicesListHelpText = DataStreamsAndIndicesListHelpText;