"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyExecuteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _http = require("../services/http");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/policy_execute_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyExecuteProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [policyName, setPolicyName] = (0, _react.useState)('');
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const executePolicyPrompt = (name, onSuccess = () => undefined) => {
    if (!name || !name.length) {
      throw new Error('No policy name specified for execution');
    }
    setIsModalOpen(true);
    setPolicyName(name);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
    setPolicyName('');
  };
  const executePolicy = () => {
    (0, _http.executePolicy)(policyName).then(({
      data,
      error
    }) => {
      const {
        snapshotName
      } = data || {
        snapshotName: undefined
      };

      // Surface success notification
      if (snapshotName) {
        const successMessage = i18n.translate('xpack.snapshotRestore.executePolicy.successNotificationTitle', {
          defaultMessage: "Policy ''{name}'' is running",
          values: {
            name: policyName
          }
        });
        toastNotifications.addSuccess(successMessage);
        if (onSuccessCallback.current) {
          onSuccessCallback.current();
        }
      }

      // Surface error notifications
      if (error) {
        const errorMessage = i18n.translate('xpack.snapshotRestore.executePolicy.errorNotificationTitle', {
          defaultMessage: "Error running policy ''{name}''",
          values: {
            name: policyName
          }
        });
        toastNotifications.addDanger(errorMessage);
      }
    });
    closeModal();
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": modalTitleId,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executePolicy.confirmModal.executePolicyTitle",
        defaultMessage: "Run ''{name}'' now?",
        values: {
          name: policyName
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      }),
      titleProps: {
        id: modalTitleId
      },
      onCancel: closeModal,
      onConfirm: executePolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executePolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executePolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Run policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }),
      "data-test-subj": "srExecutePolicyConfirmationModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, children(executePolicyPrompt), renderModal());
};
exports.PolicyExecuteProvider = PolicyExecuteProvider;