"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCollapsibleList = void 0;
var _react = require("react");
var _lib = require("../../../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maximumItemPreviewCount = 10;
const useCollapsibleList = ({
  items
}) => {
  var _csvToArray;
  const [isShowingFullList, setIsShowingFullList] = (0, _react.useState)(false);
  const itemsArray = (_csvToArray = (0, _lib.csvToArray)(items)) !== null && _csvToArray !== void 0 ? _csvToArray : [];
  const displayItems = items === undefined ? 'all' : itemsArray.slice(0, isShowingFullList ? Infinity : maximumItemPreviewCount);
  const hiddenItemsCount = itemsArray.length > maximumItemPreviewCount ? itemsArray.length - maximumItemPreviewCount : 0;
  return {
    items: displayItems,
    hiddenItemsCount,
    setIsShowingFullList,
    isShowingFullList
  };
};
exports.useCollapsibleList = useCollapsibleList;