"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedGroupings = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Takes a list of groupBy fields and the nested groupings object provided from
 * ES search results and returns a flatted object with the `groupBy` fields as keys
 * @param groupBy an array of groupBy fields
 * @param groupings a nested object of groupings
 * @returns a flattened object of groupings
 */

const getFlattenedGroupings = ({
  groupBy,
  groupings
}) => {
  const groupByFields = groupBy ? [groupBy].flat() : [];
  const hasGroupings = Object.keys(groupings !== null && groupings !== void 0 ? groupings : {}).length;
  const formattedGroupings = hasGroupings ? groupByFields.reduce((acc, group) => {
    acc[group] = `${(0, _lodash.get)(groupings, group)}`;
    return acc;
  }, {}) : {};
  return formattedGroupings;
};
exports.getFlattenedGroupings = getFlattenedGroupings;