"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSlicesFromDateRange = getSlicesFromDateRange;
var _moment = _interopRequireDefault(require("moment"));
var _models = require("../../domain/models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSlicesFromDateRange(dateRange, timesliceWindow) {
  const dateRangeDurationInUnit = (0, _moment.default)(dateRange.to).diff(dateRange.from, (0, _models.toMomentUnitOfTime)(timesliceWindow.unit));
  return Math.ceil(dateRangeDurationInUnit / timesliceWindow.value);
}