"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildBurnRateAgg = buildBurnRateAgg;
exports.getFiveMinuteRange = getFiveMinuteRange;
exports.getOneDayRange = getOneDayRange;
exports.getOneHourRange = getOneHourRange;
var _sloSchema = require("@kbn/slo-schema");
var _get_delay_in_seconds_from_slo = require("../../../domain/services/get_delay_in_seconds_from_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIVE_MINUTES_IN_SECONDS = 300;
const ONE_HOUR_IN_SECONDS = 3600;
const ONE_DAY_IN_SECONDS = 86400;
function getFiveMinuteRange(slo) {
  const delayInSeconds = (0, _get_delay_in_seconds_from_slo.getDelayInSecondsFromSLO)(slo);
  return {
    gte: `now-${FIVE_MINUTES_IN_SECONDS + delayInSeconds}s/m`,
    lte: `now-${delayInSeconds}s/m`
  };
}
function getOneHourRange(slo) {
  const delayInSeconds = (0, _get_delay_in_seconds_from_slo.getDelayInSecondsFromSLO)(slo);
  return {
    gte: `now-${ONE_HOUR_IN_SECONDS + delayInSeconds}s/m`,
    lte: `now-${delayInSeconds}s/m`
  };
}
function getOneDayRange(slo) {
  const delayInSeconds = (0, _get_delay_in_seconds_from_slo.getDelayInSecondsFromSLO)(slo);
  return {
    gte: `now-${ONE_DAY_IN_SECONDS + delayInSeconds}s/m`,
    lte: `now-${delayInSeconds}s/m`
  };
}
function buildBurnRateAgg(aggKey, slo) {
  const aggKeyToRangeMap = {
    fiveMinuteBurnRate: getFiveMinuteRange,
    oneHourBurnRate: getOneHourRange,
    oneDayBurnRate: getOneDayRange
  };
  return {
    [aggKey]: {
      filter: {
        range: {
          '@timestamp': aggKeyToRangeMap[aggKey](slo)
        }
      },
      ...(_sloSchema.occurrencesBudgetingMethodSchema.is(slo.budgetingMethod) && {
        aggs: {
          goodEvents: {
            sum: {
              field: 'slo.numerator'
            }
          },
          totalEvents: {
            sum: {
              field: 'slo.denominator'
            }
          }
        }
      }),
      ...(_sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod) && {
        aggs: {
          goodEvents: {
            sum: {
              field: 'slo.isGoodSlice'
            }
          },
          totalEvents: {
            value_count: {
              field: 'slo.isGoodSlice'
            }
          }
        }
      })
    }
  };
}