"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertPlatinumLicense = void 0;
var _boom = require("@hapi/boom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assertPlatinumLicense = async plugins => {
  const licensing = await plugins.licensing.start();
  const hasCorrectLicense = (await licensing.getLicense()).hasAtLeast('platinum');
  if (!hasCorrectLicense) {
    throw (0, _boom.forbidden)('Platinum license or higher is needed to make use of this feature.');
  }
};
exports.assertPlatinumLicense = assertPlatinumLicense;